/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import azkaban.executor.Executor;
import azkaban.executor.ExecutorInfo;
import azkaban.executor.selector.CandidateComparator;
import azkaban.executor.selector.FactorComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExecutorComparator
extends CandidateComparator<Executor> {
    private static final String NUMOFASSIGNEDFLOW_COMPARATOR_NAME = "NumberOfAssignedFlowComparator";
    private static final String MEMORY_COMPARATOR_NAME = "Memory";
    private static final String LSTDISPATCHED_COMPARATOR_NAME = "LastDispatched";
    private static final String CPUUSAGE_COMPARATOR_NAME = "CpuUsage";
    private static Map<String, ComparatorCreator> comparatorCreatorRepository = null;

    public ExecutorComparator(Map<String, Integer> comparatorList) {
        if (null == comparatorList || comparatorList.size() == 0) {
            throw new IllegalArgumentException("failed to initialize executor comparatoras the passed comparator list is invalid or empty.");
        }
        for (Map.Entry<String, Integer> entry : comparatorList.entrySet()) {
            if (comparatorCreatorRepository.containsKey(entry.getKey())) {
                this.registerFactorComparator(comparatorCreatorRepository.get(entry.getKey()).create(entry.getValue()));
                continue;
            }
            throw new IllegalArgumentException(String.format("failed to initialize executor comparator as the comparator implementation for requested factor '%s' doesn't exist.", entry.getKey()));
        }
    }

    public static Set<String> getAvailableComparatorNames() {
        return comparatorCreatorRepository.keySet();
    }

    private static boolean statisticsObjectCheck(ExecutorInfo statisticsObj1, ExecutorInfo statisticsObj2, String caller) {
        if (null == statisticsObj1 && null == statisticsObj2) {
            logger.debug((Object)String.format("%s : neither of the executors exposed statistics info.", caller));
            return true;
        }
        if (null == statisticsObj2) {
            logger.debug((Object)String.format("%s : choosing left side and the right side executor doesn't expose statistics info", caller));
            return true;
        }
        if (null == statisticsObj1) {
            logger.debug((Object)String.format("%s : choosing right side and the left side executor doesn't expose statistics info", caller));
            return true;
        }
        return false;
    }

    private static FactorComparator<Executor> getNumberOfAssignedFlowComparator(int weight) {
        return FactorComparator.create(NUMOFASSIGNEDFLOW_COMPARATOR_NAME, weight, new Comparator<Executor>(){

            @Override
            public int compare(Executor o1, Executor o2) {
                ExecutorInfo stat1 = o1.getExecutorInfo();
                ExecutorInfo stat2 = o2.getExecutorInfo();
                Integer result = 0;
                if (ExecutorComparator.statisticsObjectCheck(stat1, stat2, ExecutorComparator.NUMOFASSIGNEDFLOW_COMPARATOR_NAME)) {
                    return result;
                }
                return Integer.valueOf(stat1.getRemainingFlowCapacity()).compareTo(stat2.getRemainingFlowCapacity());
            }
        });
    }

    private static FactorComparator<Executor> getCpuUsageComparator(int weight) {
        return FactorComparator.create(CPUUSAGE_COMPARATOR_NAME, weight, new Comparator<Executor>(){

            @Override
            public int compare(Executor o1, Executor o2) {
                ExecutorInfo stat1 = o1.getExecutorInfo();
                ExecutorInfo stat2 = o2.getExecutorInfo();
                boolean result = false;
                if (ExecutorComparator.statisticsObjectCheck(stat1, stat2, ExecutorComparator.CPUUSAGE_COMPARATOR_NAME)) {
                    return 0;
                }
                return Double.valueOf(stat2.getCpuUsage()).compareTo(stat1.getCpuUsage());
            }
        });
    }

    private static FactorComparator<Executor> getLstDispatchedTimeComparator(int weight) {
        return FactorComparator.create(LSTDISPATCHED_COMPARATOR_NAME, weight, new Comparator<Executor>(){

            @Override
            public int compare(Executor o1, Executor o2) {
                ExecutorInfo stat1 = o1.getExecutorInfo();
                ExecutorInfo stat2 = o2.getExecutorInfo();
                boolean result = false;
                if (ExecutorComparator.statisticsObjectCheck(stat1, stat2, ExecutorComparator.LSTDISPATCHED_COMPARATOR_NAME)) {
                    return 0;
                }
                return Long.valueOf(stat2.getLastDispatchedTime()).compareTo(stat1.getLastDispatchedTime());
            }
        });
    }

    private static FactorComparator<Executor> getMemoryComparator(int weight) {
        return FactorComparator.create(MEMORY_COMPARATOR_NAME, weight, new Comparator<Executor>(){

            @Override
            public int compare(Executor o1, Executor o2) {
                ExecutorInfo stat1 = o1.getExecutorInfo();
                ExecutorInfo stat2 = o2.getExecutorInfo();
                boolean result = false;
                if (ExecutorComparator.statisticsObjectCheck(stat1, stat2, ExecutorComparator.MEMORY_COMPARATOR_NAME)) {
                    return 0;
                }
                if (stat1.getRemainingMemoryInMB() != stat2.getRemainingMemoryInMB()) {
                    return stat1.getRemainingMemoryInMB() > stat2.getRemainingMemoryInMB() ? 1 : -1;
                }
                return Double.compare(stat1.getRemainingMemoryPercent(), stat2.getRemainingMemoryPercent());
            }
        });
    }

    @Override
    public String getName() {
        return "ExecutorComparator";
    }

    static {
        comparatorCreatorRepository = new HashMap<String, ComparatorCreator>();
        comparatorCreatorRepository.put(NUMOFASSIGNEDFLOW_COMPARATOR_NAME, ExecutorComparator::getNumberOfAssignedFlowComparator);
        comparatorCreatorRepository.put(MEMORY_COMPARATOR_NAME, ExecutorComparator::getMemoryComparator);
        comparatorCreatorRepository.put(LSTDISPATCHED_COMPARATOR_NAME, ExecutorComparator::getLstDispatchedTimeComparator);
        comparatorCreatorRepository.put(CPUUSAGE_COMPARATOR_NAME, ExecutorComparator::getCpuUsageComparator);
    }

    private static interface ComparatorCreator {
        public FactorComparator<Executor> create(int var1);
    }
}

