/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import azkaban.executor.selector.CandidateComparator;
import azkaban.executor.selector.CandidateFilter;
import azkaban.executor.selector.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;

public class CandidateSelector<K extends Comparable<K>, V>
implements Selector<K, V> {
    private static final Logger logger = Logger.getLogger(CandidateComparator.class);
    private final CandidateFilter<K, V> filter;
    private final CandidateComparator<K> comparator;

    public CandidateSelector(CandidateFilter<K, V> filter, CandidateComparator<K> comparator) {
        this.filter = filter;
        this.comparator = comparator;
    }

    @Override
    public K getBest(Collection<K> candidateList, V dispatchingObject) {
        if (null == candidateList || candidateList.size() == 0) {
            logger.error((Object)"failed to getNext candidate as the passed candidateList is null or empty.");
            return null;
        }
        logger.debug((Object)"start candidate selection logic.");
        logger.debug((Object)String.format("candidate count before filtering: %s", candidateList.size()));
        Collection<Object> filteredList = new ArrayList();
        if (null != this.filter) {
            for (Comparable candidateInfo : candidateList) {
                if (!this.filter.filterTarget(candidateInfo, dispatchingObject)) continue;
                filteredList.add(candidateInfo);
            }
        } else {
            filteredList = candidateList;
            logger.debug((Object)"skipping the candidate filtering as the filter object is not specifed.");
        }
        logger.debug((Object)String.format("candidate count after filtering: %s", filteredList.size()));
        if (filteredList.size() == 0) {
            logger.debug((Object)"failed to select candidate as the filtered candidate list is empty.");
            return null;
        }
        if (null == this.comparator) {
            logger.debug((Object)"candidate comparator is not specified, default hash code comparator class will be used.");
        }
        Comparable executor = (Comparable)Collections.max(filteredList, this.comparator);
        logger.debug((Object)String.format("candidate selected %s", null == executor ? "(null)" : executor.toString()));
        return (K)executor;
    }

    @Override
    public String getName() {
        return "CandidateSelector";
    }
}

