/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorLogEvent;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public interface ExecutorLoader {
    public void uploadExecutableFlow(ExecutableFlow var1) throws ExecutorManagerException;

    public ExecutableFlow fetchExecutableFlow(int var1) throws ExecutorManagerException;

    public List<ExecutableFlow> fetchRecentlyFinishedFlows(Duration var1) throws ExecutorManagerException;

    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchActiveFlows() throws ExecutorManagerException;

    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchUnfinishedFlows() throws ExecutorManagerException;

    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchUnfinishedFlowsMetadata() throws ExecutorManagerException;

    public Pair<ExecutionReference, ExecutableFlow> fetchActiveFlowByExecId(int var1) throws ExecutorManagerException;

    public List<ExecutableFlow> fetchFlowHistory(int var1, int var2) throws ExecutorManagerException;

    public List<ExecutableFlow> fetchFlowHistory(int var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public List<ExecutableFlow> fetchFlowHistory(int var1, String var2, int var3, int var4, Status var5) throws ExecutorManagerException;

    public List<ExecutableFlow> fetchFlowHistory(String var1, String var2, String var3, int var4, long var5, long var7, int var9, int var10) throws ExecutorManagerException;

    public List<ExecutableFlow> fetchFlowHistory(int var1, String var2, long var3) throws ExecutorManagerException;

    public List<Executor> fetchAllExecutors() throws ExecutorManagerException;

    public List<Executor> fetchActiveExecutors() throws ExecutorManagerException;

    public Executor fetchExecutor(String var1, int var2) throws ExecutorManagerException;

    public Executor fetchExecutor(int var1) throws ExecutorManagerException;

    public Executor addExecutor(String var1, int var2) throws ExecutorManagerException;

    public void updateExecutor(Executor var1) throws ExecutorManagerException;

    public void removeExecutor(String var1, int var2) throws ExecutorManagerException;

    public void postExecutorEvent(Executor var1, ExecutorLogEvent.EventType var2, String var3, String var4) throws ExecutorManagerException;

    public List<ExecutorLogEvent> getExecutorEvents(Executor var1, int var2, int var3) throws ExecutorManagerException;

    public void addActiveExecutableReference(ExecutionReference var1) throws ExecutorManagerException;

    public void removeActiveExecutableReference(int var1) throws ExecutorManagerException;

    public void unassignExecutor(int var1) throws ExecutorManagerException;

    public void assignExecutor(int var1, int var2) throws ExecutorManagerException;

    public Executor fetchExecutorByExecutionId(int var1) throws ExecutorManagerException;

    public List<Pair<ExecutionReference, ExecutableFlow>> fetchQueuedFlows() throws ExecutorManagerException;

    public boolean updateExecutableReference(int var1, long var2) throws ExecutorManagerException;

    public FileIOUtils.LogData fetchLogs(int var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public List<Object> fetchAttachments(int var1, String var2, int var3) throws ExecutorManagerException;

    public void uploadLogFile(int var1, String var2, int var3, File ... var4) throws ExecutorManagerException;

    public void uploadAttachmentFile(ExecutableNode var1, File var2) throws ExecutorManagerException;

    public void updateExecutableFlow(ExecutableFlow var1) throws ExecutorManagerException;

    public void uploadExecutableNode(ExecutableNode var1, Props var2) throws ExecutorManagerException;

    public List<ExecutableJobInfo> fetchJobInfoAttempts(int var1, String var2) throws ExecutorManagerException;

    public ExecutableJobInfo fetchJobInfo(int var1, String var2, int var3) throws ExecutorManagerException;

    public List<ExecutableJobInfo> fetchJobHistory(int var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public void updateExecutableNode(ExecutableNode var1) throws ExecutorManagerException;

    public int fetchNumExecutableFlows(int var1, String var2) throws ExecutorManagerException;

    public int fetchNumExecutableFlows() throws ExecutorManagerException;

    public int fetchNumExecutableNodes(int var1, String var2) throws ExecutorManagerException;

    public Props fetchExecutionJobInputProps(int var1, String var2) throws ExecutorManagerException;

    public Props fetchExecutionJobOutputProps(int var1, String var2) throws ExecutorManagerException;

    public Pair<Props, Props> fetchExecutionJobProps(int var1, String var2) throws ExecutorManagerException;

    public int removeExecutionLogsByTime(long var1) throws ExecutorManagerException;

    public void unsetExecutorIdForExecution(int var1) throws ExecutorManagerException;

    public int selectAndUpdateExecution(int var1, boolean var2) throws ExecutorManagerException;
}

