/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.db.DatabaseTransOperator;
import azkaban.db.EncodingType;
import azkaban.db.SQLTransaction;
import azkaban.executor.ExecutorManagerException;
import azkaban.utils.FileIOUtils;
import azkaban.utils.GZIPUtils;
import azkaban.utils.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

@Singleton
public class ExecutionLogsDao {
    private static final Logger logger = Logger.getLogger(ExecutionLogsDao.class);
    private final DatabaseOperator dbOperator;
    private final EncodingType defaultEncodingType = EncodingType.GZIP;

    @Inject
    ExecutionLogsDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    FileIOUtils.LogData fetchLogs(int execId, String name, int attempt, int startByte, int length) throws ExecutorManagerException {
        FetchLogsHandler handler = new FetchLogsHandler(startByte, length + startByte);
        try {
            return (FileIOUtils.LogData)this.dbOperator.query("SELECT exec_id, name, attempt, enc_type, start_byte, end_byte, log FROM execution_logs WHERE exec_id=? AND name=? AND attempt=? AND end_byte > ? AND start_byte <= ? ORDER BY start_byte", (ResultSetHandler)handler, new Object[]{execId, name, attempt, startByte, startByte + length});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching logs " + execId + " : " + name, e);
        }
    }

    public void uploadLogFile(int execId, String name, int attempt, File ... files) throws ExecutorManagerException {
        SQLTransaction transaction = transOperator -> {
            this.uploadLogFile(transOperator, execId, name, attempt, files, this.defaultEncodingType);
            transOperator.getConnection().commit();
            return 1;
        };
        try {
            this.dbOperator.transaction(transaction);
        }
        catch (SQLException e) {
            logger.error((Object)"uploadLogFile failed.", (Throwable)e);
            throw new ExecutorManagerException("uploadLogFile failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadLogFile(DatabaseTransOperator transOperator, int execId, String name, int attempt, File[] files, EncodingType encType) throws SQLException {
        byte[] buffer = new byte[51200];
        int pos = 0;
        int length = buffer.length;
        int startByte = 0;
        try {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                BufferedInputStream bufferedStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    int size = bufferedStream.read(buffer, pos, length);
                    while (size >= 0) {
                        if (pos + size == buffer.length) {
                            this.uploadLogPart(transOperator, execId, name, attempt, startByte, startByte + buffer.length, encType, buffer, buffer.length);
                            pos = 0;
                            length = buffer.length;
                            startByte += buffer.length;
                        } else {
                            length = buffer.length - (pos += size);
                        }
                        size = bufferedStream.read(buffer, pos, length);
                    }
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)bufferedStream);
                }
            }
            if (pos > 0) {
                this.uploadLogPart(transOperator, execId, name, attempt, startByte, startByte + pos, encType, buffer, pos);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error writing log part.", (Throwable)e);
            throw new SQLException("Error writing log part", e);
        }
        catch (IOException e) {
            logger.error((Object)"Error chunking.", (Throwable)e);
            throw new SQLException("Error chunking", e);
        }
    }

    int removeExecutionLogsByTime(long millis) throws ExecutorManagerException {
        String DELETE_BY_TIME = "DELETE FROM execution_logs WHERE upload_time < ?";
        try {
            return this.dbOperator.update("DELETE FROM execution_logs WHERE upload_time < ?", new Object[]{millis});
        }
        catch (SQLException e) {
            logger.error((Object)"delete execution logs failed", (Throwable)e);
            throw new ExecutorManagerException("Error deleting old execution_logs before " + millis, e);
        }
    }

    private void uploadLogPart(DatabaseTransOperator transOperator, int execId, String name, int attempt, int startByte, int endByte, EncodingType encType, byte[] buffer, int length) throws SQLException, IOException {
        String INSERT_EXECUTION_LOGS = "INSERT INTO execution_logs (exec_id, name, attempt, enc_type, start_byte, end_byte, log, upload_time) VALUES (?,?,?,?,?,?,?,?)";
        byte[] buf = buffer;
        if (encType == EncodingType.GZIP) {
            buf = GZIPUtils.gzipBytes(buf, 0, length);
        } else if (length < buf.length) {
            buf = Arrays.copyOf(buffer, length);
        }
        transOperator.update("INSERT INTO execution_logs (exec_id, name, attempt, enc_type, start_byte, end_byte, log, upload_time) VALUES (?,?,?,?,?,?,?,?)", new Object[]{execId, name, attempt, encType.getNumVal(), startByte, startByte + length, buf, DateTime.now().getMillis()});
    }

    private static class FetchLogsHandler
    implements ResultSetHandler<FileIOUtils.LogData> {
        private static final String FETCH_LOGS = "SELECT exec_id, name, attempt, enc_type, start_byte, end_byte, log FROM execution_logs WHERE exec_id=? AND name=? AND attempt=? AND end_byte > ? AND start_byte <= ? ORDER BY start_byte";
        private final int startByte;
        private final int endByte;

        FetchLogsHandler(int startByte, int endByte) {
            this.startByte = startByte;
            this.endByte = endByte;
        }

        public FileIOUtils.LogData handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return null;
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            do {
                int attempt = rs.getInt(3);
                EncodingType encType = EncodingType.fromInteger((int)rs.getInt(4));
                int startByte = rs.getInt(5);
                int endByte = rs.getInt(6);
                byte[] data = rs.getBytes(7);
                int offset = this.startByte > startByte ? this.startByte - startByte : 0;
                int length = this.endByte < endByte ? this.endByte - startByte - offset : endByte - startByte - offset;
                try {
                    byte[] buffer = data;
                    if (encType == EncodingType.GZIP) {
                        buffer = GZIPUtils.unGzipBytes(data);
                    }
                    byteStream.write(buffer, offset, length);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            } while (rs.next());
            byte[] buffer = byteStream.toByteArray();
            Pair<Integer, Integer> result = FileIOUtils.getUtf8Range(buffer, 0, buffer.length);
            return new FileIOUtils.LogData(this.startByte + result.getFirst(), result.getSecond(), new String(buffer, (int)result.getFirst(), (int)result.getSecond(), StandardCharsets.UTF_8));
        }
    }
}

