/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.event.EventHandler;
import azkaban.executor.AlerterHolder;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionControllerUtils;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorApiGateway;
import azkaban.executor.ExecutorHealthChecker;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.FlowUtils;
import azkaban.metrics.CommonMetrics;
import azkaban.project.Project;
import azkaban.project.ProjectWhitelist;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutionController
extends EventHandler
implements ExecutorManagerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionController.class);
    private static final Duration RECENTLY_FINISHED_LIFETIME = Duration.ofMinutes(10L);
    private static final int DEFAULT_MAX_ONCURRENT_RUNS_ONEFLOW = 30;
    private final ExecutorLoader executorLoader;
    private final ExecutorApiGateway apiGateway;
    private final AlerterHolder alerterHolder;
    private final ExecutorHealthChecker executorHealthChecker;
    private final int maxConcurrentRunsOneFlow;
    private final CommonMetrics commonMetrics;

    @Inject
    ExecutionController(Props azkProps, ExecutorLoader executorLoader, CommonMetrics commonMetrics, ExecutorApiGateway apiGateway, AlerterHolder alerterHolder, ExecutorHealthChecker executorHealthChecker) {
        this.executorLoader = executorLoader;
        this.commonMetrics = commonMetrics;
        this.apiGateway = apiGateway;
        this.alerterHolder = alerterHolder;
        this.executorHealthChecker = executorHealthChecker;
        this.maxConcurrentRunsOneFlow = this.getMaxConcurrentRunsOneFlow(azkProps);
    }

    private int getMaxConcurrentRunsOneFlow(Props azkProps) {
        return azkProps.getInt("azkaban.max.concurrent.runs.oneflow", 30);
    }

    @Override
    public void setupExecutors() throws ExecutorManagerException {
    }

    @Override
    public void disableQueueProcessorThread() {
    }

    @Override
    public void enableQueueProcessorThread() {
    }

    @Override
    public Thread.State getExecutorManagerThreadState() {
        return Thread.State.RUNNABLE;
    }

    @Override
    public boolean isExecutorManagerThreadActive() {
        return true;
    }

    @Override
    public long getLastExecutorManagerThreadCheckTime() {
        return 1L;
    }

    @Override
    public Collection<Executor> getAllActiveExecutors() {
        ArrayList<Executor> executors = new ArrayList();
        try {
            executors = this.executorLoader.fetchActiveExecutors();
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get all active executors.", (Throwable)e);
        }
        return executors;
    }

    @Override
    public Executor fetchExecutor(int executorId) throws ExecutorManagerException {
        return this.executorLoader.fetchExecutor(executorId);
    }

    public Set<String> getPrimaryServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        try {
            for (Executor executor : this.executorLoader.fetchActiveExecutors()) {
                ports.add(executor.getHost() + ":" + executor.getPort());
            }
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get primary server hosts.", (Throwable)e);
        }
        return ports;
    }

    @Override
    public Set<String> getAllActiveExecutorServerHosts() {
        Set<String> ports = this.getPrimaryServerHosts();
        try {
            for (Pair<ExecutionReference, ExecutableFlow> running : this.executorLoader.fetchActiveFlows().values()) {
                ExecutionReference ref = running.getFirst();
                if (!ref.getExecutor().isPresent()) continue;
                Executor executor = ref.getExecutor().get();
                ports.add(executor.getHost() + ":" + executor.getPort());
            }
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get all active executor server hosts.", (Throwable)e);
        }
        return ports;
    }

    @Override
    public List<Integer> getRunningFlows(int projectId, String flowId) {
        ArrayList<Integer> executionIds = new ArrayList<Integer>();
        try {
            executionIds.addAll(this.getRunningFlowsHelper(projectId, flowId, this.executorLoader.fetchUnfinishedFlows().values()));
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get running flows for project " + projectId + ", flow " + flowId, (Throwable)e);
        }
        return executionIds;
    }

    private List<Integer> getRunningFlowsHelper(int projectId, String flowId, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        ArrayList<Integer> executionIds = new ArrayList<Integer>();
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            if (!ref.getSecond().getFlowId().equals(flowId) || ref.getSecond().getProjectId() != projectId) continue;
            executionIds.add(ref.getFirst().getExecId());
        }
        return executionIds;
    }

    @Override
    public List<Pair<ExecutableFlow, Optional<Executor>>> getActiveFlowsWithExecutor() throws IOException {
        ArrayList<Pair<ExecutableFlow, Optional<Executor>>> flows = new ArrayList<Pair<ExecutableFlow, Optional<Executor>>>();
        try {
            this.getActiveFlowsWithExecutorHelper(flows, this.executorLoader.fetchUnfinishedFlows().values());
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get active flows with executor.", (Throwable)e);
        }
        return flows;
    }

    private void getActiveFlowsWithExecutorHelper(List<Pair<ExecutableFlow, Optional<Executor>>> flows, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            flows.add(new Pair<ExecutableFlow, Optional<Executor>>(ref.getSecond(), ref.getFirst().getExecutor()));
        }
    }

    @Override
    public boolean isFlowRunning(int projectId, String flowId) {
        boolean isRunning = false;
        try {
            isRunning = this.isFlowRunningHelper(projectId, flowId, this.executorLoader.fetchUnfinishedFlows().values());
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to check if the flow is running for project " + projectId + ", flow " + flowId, (Throwable)e);
        }
        return isRunning;
    }

    private boolean isFlowRunningHelper(int projectId, String flowId, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            if (ref.getSecond().getProjectId() != projectId || !ref.getSecond().getFlowId().equals(flowId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutableFlow getExecutableFlow(int execId) throws ExecutorManagerException {
        return this.executorLoader.fetchExecutableFlow(execId);
    }

    @Override
    public List<ExecutableFlow> getRunningFlows() {
        ArrayList<ExecutableFlow> flows = new ArrayList<ExecutableFlow>();
        try {
            this.getFlowsHelper(flows, this.executorLoader.fetchUnfinishedFlows().values());
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get running flows.", (Throwable)e);
        }
        return flows;
    }

    private void getFlowsHelper(ArrayList<ExecutableFlow> flows, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        collection.stream().forEach(ref -> flows.add((ExecutableFlow)ref.getSecond()));
    }

    public List<Integer> getRunningFlowIds() {
        ArrayList<Integer> allIds = new ArrayList<Integer>();
        try {
            this.getExecutionIdsHelper(allIds, this.executorLoader.fetchUnfinishedFlows().values());
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get running flow ids.", (Throwable)e);
        }
        return allIds;
    }

    public List<Integer> getQueuedFlowIds() {
        ArrayList<Integer> allIds = new ArrayList<Integer>();
        try {
            this.getExecutionIdsHelper(allIds, this.executorLoader.fetchQueuedFlows());
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get queued flow ids.", (Throwable)e);
        }
        return allIds;
    }

    private void getExecutionIdsHelper(List<Integer> allIds, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        collection.stream().forEach(ref -> allIds.add(((ExecutableFlow)ref.getSecond()).getExecutionId()));
        Collections.sort(allIds);
    }

    @Override
    public long getQueuedFlowSize() {
        long size = 0L;
        try {
            size = this.executorLoader.fetchQueuedFlows().size();
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to get queued flow size.", (Throwable)e);
        }
        return size;
    }

    @Override
    public List<ExecutableFlow> getRecentlyFinishedFlows() {
        ArrayList<ExecutableFlow> flows = new ArrayList();
        try {
            flows = this.executorLoader.fetchRecentlyFinishedFlows(RECENTLY_FINISHED_LIFETIME);
        }
        catch (ExecutorManagerException e) {
            logger.error("Failed to fetch recently finished flows.", (Throwable)e);
        }
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(String flowIdContains, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(null, '%' + flowIdContains + '%', null, 0, -1L, -1L, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(String projContain, String flowContain, String userContain, int status, long begin, long end, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(projContain, flowContain, userContain, status, begin, end, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableJobInfo> getExecutableJobs(Project project, String jobId, int skip, int size) throws ExecutorManagerException {
        List<ExecutableJobInfo> nodes = this.executorLoader.fetchJobHistory(project.getId(), jobId, skip, size);
        return nodes;
    }

    @Override
    public int getNumberOfJobExecutions(Project project, String jobId) throws ExecutorManagerException {
        return this.executorLoader.fetchNumExecutableNodes(project.getId(), jobId);
    }

    @Override
    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow exFlow, int offset, int length) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.executorLoader.fetchActiveFlowByExecId(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "flow");
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Map<String, Object> result = this.apiGateway.callWithReference(pair.getFirst(), "log", typeParam, offsetParam, lengthParam);
            return FileIOUtils.LogData.createLogDataFromObject(result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), "", 0, offset, length);
        return value;
    }

    @Override
    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow exFlow, String jobId, int offset, int length, int attempt) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.executorLoader.fetchActiveFlowByExecId(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "job");
            Pair<String, String> jobIdParam = new Pair<String, String>("jobId", jobId);
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Pair<String, String> attemptParam = new Pair<String, String>("attempt", String.valueOf(attempt));
            Map<String, Object> result = this.apiGateway.callWithReference(pair.getFirst(), "log", typeParam, jobIdParam, offsetParam, lengthParam, attemptParam);
            return FileIOUtils.LogData.createLogDataFromObject(result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), jobId, attempt, offset, length);
        return value;
    }

    @Override
    public List<Object> getExecutionJobStats(ExecutableFlow exFlow, String jobId, int attempt) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.executorLoader.fetchActiveFlowByExecId(exFlow.getExecutionId());
        if (pair == null) {
            return this.executorLoader.fetchAttachments(exFlow.getExecutionId(), jobId, attempt);
        }
        Pair<String, String> jobIdParam = new Pair<String, String>("jobId", jobId);
        Pair<String, String> attemptParam = new Pair<String, String>("attempt", String.valueOf(attempt));
        Map<String, Object> result = this.apiGateway.callWithReference(pair.getFirst(), "attachments", jobIdParam, attemptParam);
        List jobStats = (List)result.get("attachments");
        return jobStats;
    }

    @Override
    public String getJobLinkUrl(ExecutableFlow exFlow, String jobId, int attempt) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Map<Integer, Pair<ExecutionReference, ExecutableFlow>> unfinishedFlows = this.executorLoader.fetchUnfinishedFlows();
            if (unfinishedFlows.containsKey(exFlow.getExecutionId())) {
                Pair<ExecutionReference, ExecutableFlow> pair = unfinishedFlows.get(exFlow.getExecutionId());
                if (pair.getFirst().getExecutor().isPresent()) {
                    this.apiGateway.callWithReferenceByUser(pair.getFirst(), "cancel", userId, new Pair[0]);
                } else {
                    ExecutionControllerUtils.finalizeFlow(this.executorLoader, this.alerterHolder, exFlow, "Cancelled before dispatching to executor", null);
                }
            } else {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair<ExecutionReference, ExecutableFlow> pair = this.executorLoader.fetchActiveFlowByExecId(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.apiGateway.callWithReferenceByUser(pair.getFirst(), "resume", userId, new Pair[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair<ExecutionReference, ExecutableFlow> pair = this.executorLoader.fetchActiveFlowByExecId(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.apiGateway.callWithReferenceByUser(pair.getFirst(), "pause", userId, new Pair[0]);
        }
    }

    @Override
    public void retryFailures(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "retryFailures", userId, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> modifyExecutingJobs(ExecutableFlow exFlow, String command, String userId, String ... jobIds) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Map<String, Object> response;
            Pair<ExecutionReference, ExecutableFlow> pair = this.executorLoader.fetchActiveFlowByExecId(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            if (jobIds != null && jobIds.length > 0) {
                for (String jobId : jobIds) {
                    ExecutableNode node;
                    if (jobId.isEmpty() || (node = exFlow.getExecutableNode(jobId)) != null) continue;
                    throw new ExecutorManagerException("Job " + jobId + " doesn't exist in execution " + exFlow.getExecutionId() + ".");
                }
                String ids = StringUtils.join((Object[])jobIds, (char)',');
                response = this.apiGateway.callWithReferenceByUser(pair.getFirst(), "modifyExecution", userId, new Pair<String, String>("modifyType", command), new Pair<String, String>("jobIds", ids));
            } else {
                response = this.apiGateway.callWithReferenceByUser(pair.getFirst(), "modifyExecution", userId, new Pair<String, String>("modifyType", command));
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String submitExecutableFlow(ExecutableFlow exflow, String userId) throws ExecutorManagerException {
        String exFlowKey = exflow.getProjectName() + "." + exflow.getId() + ".submitFlow";
        String string = exFlowKey.intern();
        synchronized (string) {
            String flowId = exflow.getFlowId();
            logger.info("Submitting execution flow " + flowId + " by " + userId);
            String message = "";
            int projectId = exflow.getProjectId();
            exflow.setSubmitUser(userId);
            exflow.setStatus(Status.PREPARING);
            exflow.setSubmitTime(System.currentTimeMillis());
            List<Integer> running = this.getRunningFlows(projectId, flowId);
            ExecutionOptions options = exflow.getExecutionOptions();
            if (options == null) {
                options = new ExecutionOptions();
            }
            if (options.getDisabledJobs() != null) {
                FlowUtils.applyDisabledJobs(options.getDisabledJobs(), exflow);
            }
            if (!running.isEmpty()) {
                if (running.size() > this.maxConcurrentRunsOneFlow) {
                    this.commonMetrics.markSubmitFlowSkip();
                    throw new ExecutorManagerException("Flow " + flowId + " has more than " + this.maxConcurrentRunsOneFlow + " concurrent runs. Skipping", ExecutorManagerException.Reason.SkippedExecution);
                }
                if (options.getConcurrentOption().equals("pipeline")) {
                    Collections.sort(running);
                    Integer runningExecId = running.get(running.size() - 1);
                    options.setPipelineExecutionId(runningExecId);
                    message = "Flow " + flowId + " is already running with exec id " + runningExecId + ". Pipelining level " + options.getPipelineLevel() + ". \n";
                } else {
                    if (options.getConcurrentOption().equals("skip")) {
                        this.commonMetrics.markSubmitFlowSkip();
                        throw new ExecutorManagerException("Flow " + flowId + " is already running. Skipping execution.", ExecutorManagerException.Reason.SkippedExecution);
                    }
                    message = "Flow " + flowId + " is already running with exec id " + StringUtils.join(running, (String)",") + ". Will execute concurrently. \n";
                }
            }
            boolean memoryCheck = !ProjectWhitelist.isProjectWhitelisted(exflow.getProjectId(), ProjectWhitelist.WhitelistType.MemoryCheck);
            options.setMemoryCheck(memoryCheck);
            this.executorLoader.uploadExecutableFlow(exflow);
            this.commonMetrics.markSubmitFlowSuccess();
            message = message + "Execution queued successfully with exec id " + exflow.getExecutionId();
            return message;
        }
    }

    @Override
    public Map<String, Object> callExecutorStats(int executorId, String action, Pair<String, String> ... params) throws IOException, ExecutorManagerException {
        Executor executor = this.fetchExecutor(executorId);
        ArrayList<Pair<String, String>> paramList = new ArrayList<Pair<String, String>>();
        if (params != null) {
            paramList.addAll(Arrays.asList(params));
        }
        paramList.add(new Pair<String, String>("action", action));
        return this.apiGateway.callForJsonObjectMap(executor.getHost(), executor.getPort(), "/stats", paramList);
    }

    @Override
    public Map<String, Object> callExecutorJMX(String hostPort, String action, String mBean) throws IOException {
        ArrayList<Pair<String, String>> paramList = new ArrayList<Pair<String, String>>();
        paramList.add(new Pair<String, String>(action, ""));
        if (mBean != null) {
            paramList.add(new Pair<String, String>("mBean", mBean));
        }
        String[] hostPortSplit = hostPort.split(":");
        return this.apiGateway.callForJsonObjectMap(hostPortSplit[0], Integer.valueOf(hostPortSplit[1]), "/jmx", paramList);
    }

    @Override
    public void start() {
        this.executorHealthChecker.start();
    }

    @Override
    public void shutdown() {
        this.executorHealthChecker.shutdown();
    }

    @Override
    public int getExecutableFlows(int projectId, String flowId, int from, int length, List<ExecutableFlow> outputList) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(projectId, flowId, from, length);
        outputList.addAll(flows);
        return this.executorLoader.fetchNumExecutableFlows(projectId, flowId);
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(int projectId, String flowId, int from, int length, Status status) throws ExecutorManagerException {
        return this.executorLoader.fetchFlowHistory(projectId, flowId, from, length, status);
    }
}

