/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.Executor;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerException;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class ActiveExecutors {
    private static final Logger logger = Logger.getLogger(ExecutorManager.class);
    private volatile ImmutableSet<Executor> activeExecutors;
    private final ExecutorLoader executorLoader;

    @Inject
    public ActiveExecutors(ExecutorLoader executorLoader) {
        this.executorLoader = executorLoader;
    }

    public void setupExecutors() throws ExecutorManagerException {
        ImmutableSet<Executor> newExecutors = this.loadExecutors();
        if (newExecutors.isEmpty()) {
            String error = "No active executors found";
            logger.error((Object)"No active executors found");
            throw new ExecutorManagerException("No active executors found");
        }
        this.activeExecutors = newExecutors;
    }

    public Collection<Executor> getAll() {
        return this.activeExecutors;
    }

    private ImmutableSet<Executor> loadExecutors() throws ExecutorManagerException {
        logger.info((Object)"Initializing executors from database.");
        return ImmutableSet.copyOf(this.executorLoader.fetchActiveExecutors());
    }
}

