/*
 * Decompiled with CFR 0.152.
 */
package azkaban;

import azkaban.storage.StorageImplementationType;
import azkaban.utils.Props;
import java.net.URI;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class AzkabanCommonModuleConfig {
    private static final Logger log = Logger.getLogger(AzkabanCommonModuleConfig.class);
    private final Props props;
    private final URI hdfsRootUri;
    private String storageImplementation = StorageImplementationType.DATABASE.name();
    private String localStorageBaseDirPath = "LOCAL_STORAGE";

    @Inject
    public AzkabanCommonModuleConfig(Props props) {
        this.props = props;
        this.storageImplementation = props.getString("azkaban.storage.type", this.storageImplementation);
        this.localStorageBaseDirPath = props.getString("azkaban.storage.local.basedir", this.localStorageBaseDirPath);
        this.hdfsRootUri = props.get((Object)"azkaban.storage.hdfs.root.uri") != null ? props.getUri("azkaban.storage.hdfs.root.uri") : null;
    }

    public Props getProps() {
        return this.props;
    }

    public String getStorageImplementation() {
        return this.storageImplementation;
    }

    public String getLocalStorageBaseDirPath() {
        return this.localStorageBaseDirPath;
    }

    public URI getHdfsRootUri() {
        return this.hdfsRootUri;
    }
}

