/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.fileform;

import com.aliyun.fileform.models.FileField;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public class FileFormInputStream
extends InputStream {
    private Map<String, Object> form;
    private String boundary;
    private String[] keys;
    private int keyIndex = 0;
    private int fileNumber = 0;
    private ArrayList<FileField> files = new ArrayList();
    private ByteArrayInputStream fileBodyStream = new ByteArrayInputStream(new byte[0]);
    private InputStream temporaryStream = new ByteArrayInputStream(new byte[0]);
    private ByteArrayInputStream temporaryEndStream = new ByteArrayInputStream(new byte[0]);
    private ByteArrayInputStream endInputStream;

    public FileFormInputStream(Map<String, Object> form, String boundary) {
        this.boundary = boundary;
        this.form = form;
        this.keys = form.keySet().toArray(new String[0]);
        try {
            this.endInputStream = new ByteArrayInputStream(("--" + boundary + "--\r\n").getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        this.keyIndex = 0;
        this.fileNumber = 0;
        this.files.clear();
        this.fileBodyStream = new ByteArrayInputStream(new byte[0]);
        this.temporaryStream = new ByteArrayInputStream(new byte[0]);
        this.temporaryEndStream = new ByteArrayInputStream(new byte[0]);
        this.endInputStream.reset();
    }

    @Override
    public int read() {
        return -1;
    }

    @Override
    public int read(byte[] bytes) {
        try {
            int index = this.fileBodyStream.read(bytes);
            if (index != -1) {
                return index;
            }
            index = this.temporaryStream.read(bytes);
            if (index != -1) {
                return index;
            }
            index = this.temporaryEndStream.read(bytes);
            if (index != -1) {
                return index;
            }
            if (this.keyIndex < this.keys.length) {
                Object value = this.form.get(this.keys[this.keyIndex]);
                if (null == value) {
                    ++this.keyIndex;
                    return this.read(bytes);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (value instanceof FileField) {
                    FileField fileMap = (FileField)((Object)value);
                    this.files.add(fileMap);
                    ++this.fileNumber;
                } else {
                    stringBuilder.append("--").append(this.boundary).append("\r\n");
                    stringBuilder.append("Content-Disposition: form-data; name=\"").append(this.keys[this.keyIndex]).append("\"\r\n\r\n");
                    stringBuilder.append(value).append("\r\n");
                }
                this.fileBodyStream = new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
                ++this.keyIndex;
                return this.read(bytes);
            }
            if (this.keyIndex >= this.keys.length && this.fileNumber > 0) {
                FileField fileMap = this.files.get(this.fileNumber - 1);
                --this.fileNumber;
                if (fileMap.content instanceof InputStream) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("--").append(this.boundary).append("\r\n");
                    stringBuilder.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(fileMap.filename).append("\"\r\n");
                    stringBuilder.append("Content-Type: ").append(fileMap.contentType).append("\r\n\r\n");
                    this.temporaryStream = fileMap.content;
                    this.temporaryEndStream = new ByteArrayInputStream("\r\n".getBytes("UTF-8"));
                    this.fileBodyStream = new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
                }
                return this.read(bytes);
            }
            index = this.endInputStream.read(bytes);
            if (index != -1) {
                return index;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return -1;
    }
}

