/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(PigNodeConvert.class);

    public PigNodeConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public PigNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.pigNodeType", CodeProgramType.ODPS_SQL.getName()));
        if (workflowNode.getCustomProperties().get("prepareScript") != null) {
            WorkflowNode shellNode = new WorkflowNode();
            shellNode.setNodeId(workflowNode.getNodeId() + "_shell");
            shellNode.setNodeName(workflowNode.getNodeName() + "_shell");
            if (tgtworkflowNode.getNodeType().equals(CodeProgramType.EMR_MR.getName())) {
                shellNode.setNodeType(CodeProgramType.EMR_SHELL.getName());
            } else if (tgtworkflowNode.getNodeType().equals(CodeProgramType.ODPS_MR.getName())) {
                shellNode.setNodeType(CodeProgramType.DIDE_SHELL.getName());
            } else if (tgtworkflowNode.getNodeType().equals(CodeProgramType.CDH_MR.getName())) {
                shellNode.setNodeType(CodeProgramType.CDH_SHELL.getName());
            } else {
                shellNode.setNodeType(CodeProgramType.DIDE_SHELL.getName());
            }
            StringBuilder toShellscript = new StringBuilder();
            String prepareScript = workflowNode.getCustomProperties().get("prepareScript").toString();
            String[] ListString = prepareScript.split("; ");
            String[] deleteListString = ListString[0].substring("deleteList: {".length(), ListString[0].length() - 1).split(",");
            String[] mkdirListString = ListString[1].substring("mkdirList: {".length(), ListString[1].length() - 1).split(",");
            if (!deleteListString[0].equals("")) {
                for (String deletePath : deleteListString) {
                    toShellscript.append("delete ").append(deletePath).append("\n");
                }
            }
            if (!mkdirListString[0].equals("")) {
                for (String mkdirPath : mkdirListString) {
                    toShellscript.append("mkdir ").append(mkdirPath).append("\n");
                }
            }
            shellNode.setScript(toShellscript.toString());
            this.workflow.getNodeRelations().add(new RelationPackage(shellNode.getNodeId(), workflowNode.getNodeId(), RelationPackage.ReType.NODE));
            tgtNodes.add(shellNode);
        }
        StringBuilder script = new StringBuilder();
        for (WorkflowFileResource file : workflowNode.getFiles()) {
            script.append("##@resource_reference{\"").append(file.getPath()).append("\"}\n").append(file.getPath()).append("\n\n");
        }
        if (tgtworkflowNode.getScript() != null) {
            script.append(tgtworkflowNode.getScript());
        }
        tgtworkflowNode.setScript(script.toString());
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }
}

