/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(JavaNodeConvert.class);

    public JavaNodeConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public JavaNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.javaNodeType", CodeProgramType.EMR_SHELL.getName()));
        StringBuilder script = new StringBuilder();
        if (workflowNode.getCustomProperties().get("prepareScript") != null) {
            String prepareScript = workflowNode.getCustomProperties().get("prepareScript").toString();
            String[] ListString = prepareScript.split("; ");
            String[] deleteListString = ListString[0].substring("deleteList:{".length(), ListString[0].length() - 1).split(",");
            String[] mkdirListString = ListString[1].substring("mkdirList:{".length(), ListString[1].length() - 1).split(",");
            for (String deletePath : deleteListString) {
                script.append("delete ").append(deletePath).append("\n");
            }
            for (String mkdirPath : mkdirListString) {
                script.append("mkdir ").append(mkdirPath).append("\n");
            }
        }
        for (WorkflowFileResource file : workflowNode.getFiles()) {
            script.append("##@resource_reference{\"").append(file.getPath()).append("\"}\n").append(file.getPath()).append("\n\n");
        }
        script.append("# Apache Oozie havent give the jar name in Java Node, please give it manually");
        script.append("hadoop jar ").append("[give jar name here]").append(workflowNode.getCustomProperties().get("javaMainClass").toString());
        if (workflowNode.getCustomProperties().get("javaOpts") != null) {
            script.append(" ").append(workflowNode.getCustomProperties().get("javaOpts").toString());
        }
        tgtworkflowNode.setScript(script.toString());
        return List.of(tgtworkflowNode);
    }
}

