/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.workflow;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.workflow.Credential;
import org.apache.oozie.fluentjob.api.workflow.Credentials;
import org.apache.oozie.fluentjob.api.workflow.CredentialsBuilder;
import org.apache.oozie.fluentjob.api.workflow.Global;
import org.apache.oozie.fluentjob.api.workflow.GlobalBuilder;
import org.apache.oozie.fluentjob.api.workflow.Parameters;
import org.apache.oozie.fluentjob.api.workflow.ParametersBuilder;
import org.apache.oozie.fluentjob.api.workflow.Workflow;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class WorkflowBuilder
implements Builder<Workflow> {
    private final ModifyOnce<String> name = new ModifyOnce();
    private final List<Node> addedActions = new ArrayList<Node>();
    private ParametersBuilder parametersBuilder;
    private GlobalBuilder globalBuilder;
    private CredentialsBuilder credentialsBuilder;

    public WorkflowBuilder withName(String name) {
        this.name.set(name);
        return this;
    }

    public WorkflowBuilder withDagContainingNode(Node node) {
        this.addedActions.add(node);
        return this;
    }

    public WorkflowBuilder withParameter(String name, String value) {
        this.ensureParametersBuilder();
        this.parametersBuilder.withParameter(name, value);
        return this;
    }

    public WorkflowBuilder withParameter(String name, String value, String description) {
        this.parametersBuilder.withParameter(name, value, description);
        return this;
    }

    private void ensureParametersBuilder() {
        if (this.parametersBuilder == null) {
            this.parametersBuilder = ParametersBuilder.create();
        }
    }

    public WorkflowBuilder withGlobal(Global global) {
        this.globalBuilder = GlobalBuilder.createFromExisting(global);
        return this;
    }

    public WorkflowBuilder withCredentials(Credentials credentials) {
        this.credentialsBuilder = CredentialsBuilder.createFromExisting(credentials);
        return this;
    }

    @Override
    public Workflow build() {
        Credentials credentials;
        this.ensureName();
        HashSet<Node> nodes = new HashSet<Node>();
        for (Node node : this.addedActions) {
            if (nodes.contains(node)) continue;
            nodes.addAll(WorkflowBuilder.getNodesInDag(node));
        }
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll(nodes);
        Parameters parameters = this.parametersBuilder != null ? this.parametersBuilder.build() : null;
        Global global = this.globalBuilder != null ? this.globalBuilder.build() : null;
        if (this.credentialsBuilder != null) {
            credentials = this.credentialsBuilder.build();
        } else {
            CredentialsBuilder actionCredentialsBuilder = CredentialsBuilder.create();
            for (Node action : this.addedActions) {
                for (Credential actionCredential : action.getCredentials()) {
                    actionCredentialsBuilder.withCredential(actionCredential);
                }
            }
            Credentials actionCredentials = actionCredentialsBuilder.build();
            credentials = actionCredentials.getCredentials().size() > 0 ? actionCredentialsBuilder.build() : null;
        }
        return new Workflow(this.name.get(), (ImmutableSet<Node>)builder.build(), parameters, global, credentials);
    }

    private void ensureName() {
        if (Strings.isNullOrEmpty((String)this.name.get())) {
            String type = "workflow";
            int randomSuffix = new SecureRandom().nextInt(1000000000);
            this.name.set(String.format("%s-%d", "workflow", randomSuffix));
        }
    }

    private static Set<Node> getNodesInDag(Node node) {
        Node current;
        HashSet<Node> visited = new HashSet<Node>();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        visited.add(node);
        queue.add(node);
        while ((current = (Node)queue.poll()) != null) {
            WorkflowBuilder.visit(current.getAllParents(), visited, queue);
            WorkflowBuilder.visit(current.getAllChildren(), visited, queue);
        }
        return visited;
    }

    private static void visit(List<Node> toVisit, Set<Node> visited, Queue<Node> queue) {
        for (Node node : toVisit) {
            if (visited.contains(node)) continue;
            visited.add(node);
            queue.add(node);
        }
    }
}

