/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import java.util.ArrayList;
import org.apache.oozie.fluentjob.api.action.Delete;
import org.apache.oozie.fluentjob.api.action.Mkdir;
import org.apache.oozie.fluentjob.api.action.Prepare;
import org.apache.oozie.fluentjob.api.generated.action.hive2.DELETE;
import org.apache.oozie.fluentjob.api.generated.action.hive2.MKDIR;
import org.apache.oozie.fluentjob.api.generated.action.hive2.ObjectFactory;
import org.apache.oozie.fluentjob.api.generated.action.hive2.PREPARE;

public class Hive2PrepareConverter
extends DozerConverter<Prepare, PREPARE> {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public Hive2PrepareConverter() {
        super(Prepare.class, PREPARE.class);
    }

    public PREPARE convertTo(Prepare source, PREPARE destination) {
        if (source == null) {
            return null;
        }
        destination = this.ensureDestination(destination);
        this.mapDeletes(source, destination);
        this.mapMkdirs(source, destination);
        return destination;
    }

    private PREPARE ensureDestination(PREPARE destination) {
        if (destination == null) {
            return OBJECT_FACTORY.createPREPARE();
        }
        return destination;
    }

    private void mapDeletes(Prepare source, PREPARE destination) {
        if (source.getDeletes() != null) {
            ArrayList<DELETE> targetDeletes = new ArrayList<DELETE>();
            for (Delete sourceDelete : source.getDeletes()) {
                DELETE targetDelete = OBJECT_FACTORY.createDELETE();
                targetDelete.setPath(sourceDelete.getPath());
                targetDeletes.add(targetDelete);
            }
            destination.setDelete(targetDeletes);
        }
    }

    private void mapMkdirs(Prepare source, PREPARE destination) {
        if (source.getMkdirs() != null) {
            ArrayList<MKDIR> targetMkdirs = new ArrayList<MKDIR>();
            for (Mkdir sourceMkDir : source.getMkdirs()) {
                MKDIR targetMkDir = OBJECT_FACTORY.createMKDIR();
                targetMkDir.setPath(sourceMkDir.getPath());
                targetMkdirs.add(targetMkDir);
            }
            destination.setMkdir(targetMkdirs);
        }
    }

    public Prepare convertFrom(PREPARE source, Prepare destination) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }
}

