/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MapperAware;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXBElement;
import org.apache.oozie.fluentjob.api.action.DistcpAction;
import org.apache.oozie.fluentjob.api.action.EmailAction;
import org.apache.oozie.fluentjob.api.action.FSAction;
import org.apache.oozie.fluentjob.api.action.GitAction;
import org.apache.oozie.fluentjob.api.action.Hive2Action;
import org.apache.oozie.fluentjob.api.action.HiveAction;
import org.apache.oozie.fluentjob.api.action.JavaAction;
import org.apache.oozie.fluentjob.api.action.MapReduceAction;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.PigAction;
import org.apache.oozie.fluentjob.api.action.ShellAction;
import org.apache.oozie.fluentjob.api.action.SparkAction;
import org.apache.oozie.fluentjob.api.action.SqoopAction;
import org.apache.oozie.fluentjob.api.action.SshAction;
import org.apache.oozie.fluentjob.api.action.SubWorkflowAction;
import org.apache.oozie.fluentjob.api.dag.DecisionJoin;
import org.apache.oozie.fluentjob.api.dag.ExplicitNode;
import org.apache.oozie.fluentjob.api.dag.NodeBase;
import org.apache.oozie.fluentjob.api.generated.action.hive.ObjectFactory;
import org.apache.oozie.fluentjob.api.generated.action.ssh.ACTION;
import org.apache.oozie.fluentjob.api.generated.workflow.ACTIONTRANSITION;
import org.apache.oozie.fluentjob.api.generated.workflow.FS;
import org.apache.oozie.fluentjob.api.generated.workflow.JAVA;
import org.apache.oozie.fluentjob.api.generated.workflow.MAPREDUCE;
import org.apache.oozie.fluentjob.api.generated.workflow.PIG;
import org.apache.oozie.fluentjob.api.generated.workflow.SUBWORKFLOW;
import org.apache.oozie.fluentjob.api.workflow.Credential;

public class ExplicitNodeConverter
extends DozerConverter<ExplicitNode, org.apache.oozie.fluentjob.api.generated.workflow.ACTION>
implements MapperAware {
    private static final org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory WORKFLOW_OBJECT_FACTORY = new org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory();
    private static final Map<Class<? extends Node>, Class<? extends Object>> ACTION_CLASSES = ExplicitNodeConverter.initActionClasses();
    private Mapper mapper;

    private static Map<Class<? extends Node>, Class<? extends Object>> initActionClasses() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put(MapReduceAction.class, MAPREDUCE.class).put(SubWorkflowAction.class, SUBWORKFLOW.class).put(FSAction.class, FS.class).put(EmailAction.class, org.apache.oozie.fluentjob.api.generated.action.email.ACTION.class).put(DistcpAction.class, org.apache.oozie.fluentjob.api.generated.action.distcp.ACTION.class).put(HiveAction.class, org.apache.oozie.fluentjob.api.generated.action.hive.ACTION.class).put(GitAction.class, org.apache.oozie.fluentjob.api.generated.action.git.ACTION.class).put(Hive2Action.class, org.apache.oozie.fluentjob.api.generated.action.hive2.ACTION.class).put(JavaAction.class, JAVA.class).put(PigAction.class, PIG.class).put(ShellAction.class, org.apache.oozie.fluentjob.api.generated.action.shell.ACTION.class).put(SparkAction.class, org.apache.oozie.fluentjob.api.generated.action.spark.ACTION.class).put(SqoopAction.class, org.apache.oozie.fluentjob.api.generated.action.sqoop.ACTION.class).put(SshAction.class, ACTION.class);
        return builder.build();
    }

    public ExplicitNodeConverter() {
        super(ExplicitNode.class, org.apache.oozie.fluentjob.api.generated.workflow.ACTION.class);
    }

    public org.apache.oozie.fluentjob.api.generated.workflow.ACTION convertTo(ExplicitNode source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        destination = this.ensureDestination(destination);
        this.mapAttributes(source, destination);
        this.mapTransitions(source, destination);
        this.mapActionContent(source, destination);
        return destination;
    }

    private org.apache.oozie.fluentjob.api.generated.workflow.ACTION ensureDestination(org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        if (destination == null) {
            destination = WORKFLOW_OBJECT_FACTORY.createACTION();
        }
        return destination;
    }

    public ExplicitNode convertFrom(org.apache.oozie.fluentjob.api.generated.workflow.ACTION source, ExplicitNode destination) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }

    private Mapper checkAndGetMapper() {
        Objects.requireNonNull(this.mapper, "mapper should be set");
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    private void mapAttributes(ExplicitNode source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        Integer retryMax;
        Integer retryInterval;
        destination.setName(source.getName());
        StringBuilder credBuilder = new StringBuilder();
        for (Credential credential : source.getRealNode().getCredentials()) {
            if (credBuilder.length() > 0) {
                credBuilder.append(",");
            }
            credBuilder.append(credential.getName());
        }
        if (!Strings.isNullOrEmpty((String)credBuilder.toString())) {
            destination.setCred(credBuilder.toString());
        }
        if ((retryInterval = source.getRealNode().getRetryInterval()) != null) {
            destination.setRetryInterval(retryInterval.toString());
        }
        if ((retryMax = source.getRealNode().getRetryMax()) != null) {
            destination.setRetryMax(retryMax.toString());
        }
        if (!Strings.isNullOrEmpty((String)source.getRealNode().getRetryPolicy())) {
            destination.setRetryPolicy(source.getRealNode().getRetryPolicy());
        }
    }

    private void mapTransitions(ExplicitNode source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        ACTIONTRANSITION ok = WORKFLOW_OBJECT_FACTORY.createACTIONTRANSITION();
        NodeBase child = this.findNonDecisionNodeDescendant(source);
        ok.setTo(child == null ? "" : child.getName());
        destination.setOk(ok);
    }

    private NodeBase findNonDecisionNodeDescendant(ExplicitNode source) {
        if (source.getChild() instanceof DecisionJoin) {
            return ((DecisionJoin)source.getChild()).getFirstNonDecisionJoinDescendant();
        }
        return source.getChild();
    }

    private void mapActionContent(ExplicitNode source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        Node realNode = source.getRealNode();
        Object actionTypeObject = null;
        if (ACTION_CLASSES.containsKey(realNode.getClass())) {
            Class<? extends Object> mappedClass = ACTION_CLASSES.get(realNode.getClass());
            actionTypeObject = this.checkAndGetMapper().map((Object)realNode, mappedClass);
        }
        Objects.requireNonNull(actionTypeObject, "actionTypeObject cannot be null");
        if (actionTypeObject instanceof MAPREDUCE) {
            destination.setMapReduce((MAPREDUCE)actionTypeObject);
        } else if (actionTypeObject instanceof PIG) {
            destination.setPig((PIG)actionTypeObject);
        } else if (actionTypeObject instanceof SUBWORKFLOW) {
            destination.setSubWorkflow((SUBWORKFLOW)actionTypeObject);
        } else if (actionTypeObject instanceof FS) {
            destination.setFs((FS)actionTypeObject);
        } else if (actionTypeObject instanceof JAVA) {
            destination.setJava((JAVA)actionTypeObject);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.email.ACTION) {
            this.setEmail((org.apache.oozie.fluentjob.api.generated.action.email.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.distcp.ACTION) {
            this.setDistcp((org.apache.oozie.fluentjob.api.generated.action.distcp.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.git.ACTION) {
            this.setGit((org.apache.oozie.fluentjob.api.generated.action.git.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.hive.ACTION) {
            this.setHive((org.apache.oozie.fluentjob.api.generated.action.hive.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.hive2.ACTION) {
            this.setHive2((org.apache.oozie.fluentjob.api.generated.action.hive2.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.shell.ACTION) {
            this.setShell((org.apache.oozie.fluentjob.api.generated.action.shell.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.spark.ACTION) {
            this.setSpark((org.apache.oozie.fluentjob.api.generated.action.spark.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof org.apache.oozie.fluentjob.api.generated.action.sqoop.ACTION) {
            this.setSqoop((org.apache.oozie.fluentjob.api.generated.action.sqoop.ACTION)actionTypeObject, destination);
        } else if (actionTypeObject instanceof ACTION) {
            this.setSsh((ACTION)actionTypeObject, destination);
        }
    }

    private void setEmail(org.apache.oozie.fluentjob.api.generated.action.email.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.email.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.email.ObjectFactory().createEmail(source);
        destination.setOther(jaxbElement);
    }

    private void setDistcp(org.apache.oozie.fluentjob.api.generated.action.distcp.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.distcp.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.distcp.ObjectFactory().createDistcp(source);
        destination.setOther(jaxbElement);
    }

    private void setGit(org.apache.oozie.fluentjob.api.generated.action.git.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.git.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.git.ObjectFactory().createGit(source);
        destination.setOther(jaxbElement);
    }

    private void setHive(org.apache.oozie.fluentjob.api.generated.action.hive.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.hive.ACTION> jaxbElement = new ObjectFactory().createHive(source);
        destination.setOther(jaxbElement);
    }

    private void setHive2(org.apache.oozie.fluentjob.api.generated.action.hive2.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.hive2.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.hive2.ObjectFactory().createHive2(source);
        destination.setOther(jaxbElement);
    }

    private void setJava(JAVA source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<JAVA> jaxbElement = new org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory().createJava(source);
        destination.setOther(jaxbElement);
    }

    private void setPig(PIG source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<PIG> jaxbElement = new org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory().createPig(source);
        destination.setOther(jaxbElement);
    }

    private void setShell(org.apache.oozie.fluentjob.api.generated.action.shell.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.shell.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.shell.ObjectFactory().createShell(source);
        destination.setOther(jaxbElement);
    }

    private void setSpark(org.apache.oozie.fluentjob.api.generated.action.spark.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.spark.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.spark.ObjectFactory().createSpark(source);
        destination.setOther(jaxbElement);
    }

    private void setSqoop(org.apache.oozie.fluentjob.api.generated.action.sqoop.ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<org.apache.oozie.fluentjob.api.generated.action.sqoop.ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.sqoop.ObjectFactory().createSqoop(source);
        destination.setOther(jaxbElement);
    }

    private void setSsh(ACTION source, org.apache.oozie.fluentjob.api.generated.workflow.ACTION destination) {
        JAXBElement<ACTION> jaxbElement = new org.apache.oozie.fluentjob.api.generated.action.ssh.ObjectFactory().createSsh(source);
        destination.setOther(jaxbElement);
    }
}

