/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import org.apache.oozie.fluentjob.api.generated.workflow.CREDENTIAL;
import org.apache.oozie.fluentjob.api.generated.workflow.CREDENTIALS;
import org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory;
import org.apache.oozie.fluentjob.api.workflow.ConfigurationEntry;
import org.apache.oozie.fluentjob.api.workflow.Credential;
import org.apache.oozie.fluentjob.api.workflow.Credentials;

public class CredentialsConverter
extends DozerConverter<Credentials, CREDENTIALS> {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public CredentialsConverter() {
        super(Credentials.class, CREDENTIALS.class);
    }

    public CREDENTIALS convertTo(Credentials source, CREDENTIALS destination) {
        if (source == null) {
            return null;
        }
        destination = this.ensureDestination(destination);
        this.mapCredentials(source, destination);
        return destination;
    }

    private CREDENTIALS ensureDestination(CREDENTIALS destination) {
        if (destination == null) {
            return OBJECT_FACTORY.createCREDENTIALS();
        }
        return destination;
    }

    private void mapCredentials(Credentials source, CREDENTIALS destination) {
        if (source.getCredentials() == null) {
            return;
        }
        for (Credential credential : source.getCredentials()) {
            CREDENTIAL mappedCredential = OBJECT_FACTORY.createCREDENTIAL();
            mappedCredential.setName(credential.getName());
            mappedCredential.setType(credential.getType());
            this.mapConfigurationEntries(credential, mappedCredential);
            destination.getCredential().add(mappedCredential);
        }
    }

    private void mapConfigurationEntries(Credential source, CREDENTIAL destination) {
        if (source.getConfigurationEntries() == null) {
            return;
        }
        for (ConfigurationEntry configurationEntry : source.getConfigurationEntries()) {
            CREDENTIAL.Property mappedProperty = OBJECT_FACTORY.createCREDENTIALProperty();
            mappedProperty.setName(configurationEntry.getName());
            mappedProperty.setValue(configurationEntry.getValue());
            mappedProperty.setDescription(configurationEntry.getDescription());
            destination.getProperty().add(mappedProperty);
        }
    }

    public Credentials convertFrom(CREDENTIALS source, Credentials destination) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }
}

