/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Streaming;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StreamingBuilder
implements Builder<Streaming> {
    private final ModifyOnce<String> mapper = new ModifyOnce();
    private final ModifyOnce<String> reducer = new ModifyOnce();
    private final ModifyOnce<String> recordReader = new ModifyOnce();
    private final ImmutableList.Builder<String> recordReaderMappings = new ImmutableList.Builder();
    private final ImmutableList.Builder<String> envs = new ImmutableList.Builder();

    public StreamingBuilder withMapper(String mapper) {
        this.mapper.set(mapper);
        return this;
    }

    public StreamingBuilder withReducer(String reducer) {
        this.reducer.set(reducer);
        return this;
    }

    public StreamingBuilder withRecordReader(String recordReader) {
        this.recordReader.set(recordReader);
        return this;
    }

    public StreamingBuilder withRecordReaderMapping(String recordReaderMapping) {
        this.recordReaderMappings.add((Object)recordReaderMapping);
        return this;
    }

    public StreamingBuilder withEnv(String env) {
        this.envs.add((Object)env);
        return this;
    }

    @Override
    public Streaming build() {
        return new Streaming(this.mapper.get(), this.reducer.get(), this.recordReader.get(), (ImmutableList<String>)this.recordReaderMappings.build(), (ImmutableList<String>)this.envs.build());
    }
}

