/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.SshAction;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SshActionBuilder
extends NodeBuilderBaseImpl<SshActionBuilder>
implements Builder<SshAction> {
    private final ActionAttributesBuilder attributesBuilder;
    private final ModifyOnce<String> host;
    private final ModifyOnce<String> command;

    public static SshActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> host = new ModifyOnce<String>();
        ModifyOnce<String> command = new ModifyOnce<String>();
        return new SshActionBuilder(null, builder, host, command);
    }

    public static SshActionBuilder createFromExistingAction(SshAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> host = new ModifyOnce<String>(action.getHost());
        ModifyOnce<String> command = new ModifyOnce<String>(action.getCommand());
        return new SshActionBuilder(action, builder, host, command);
    }

    public static SshActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> host = new ModifyOnce<String>();
        ModifyOnce<String> command = new ModifyOnce<String>();
        return new SshActionBuilder(action, builder, host, command);
    }

    private SshActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> host, ModifyOnce<String> command) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.host = host;
        this.command = command;
    }

    public SshActionBuilder withHost(String host) {
        this.host.set(host);
        return this;
    }

    public SshActionBuilder withCommand(String command) {
        this.command.set(command);
        return this;
    }

    public SshActionBuilder withArg(String arg) {
        this.attributesBuilder.withArg(arg);
        return this;
    }

    public SshActionBuilder withoutArg(String arg) {
        this.attributesBuilder.withoutArg(arg);
        return this;
    }

    public SshActionBuilder clearArgs() {
        this.attributesBuilder.clearArgs();
        return this;
    }

    public SshActionBuilder withCaptureOutput(Boolean captureOutput) {
        this.attributesBuilder.withCaptureOutput(captureOutput);
        return this;
    }

    @Override
    public SshAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        SshAction instance = new SshAction(constructionData, this.attributesBuilder.build(), this.host.get(), this.command.get());
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected SshActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

