/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.ActionAttributes;
import org.apache.oozie.fluentjob.api.action.HasAttributes;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SparkAction
extends Node
implements HasAttributes {
    private final ActionAttributes attributes;
    private final String master;
    private final String mode;
    private final String actionName;
    private final String actionClass;
    private final String jar;
    private final String sparkOpts;

    public SparkAction(Node.ConstructionData constructionData, ActionAttributes attributes, String master, String mode, String actionName, String actionClass, String jar, String sparkOpts) {
        super(constructionData);
        this.attributes = attributes;
        this.master = master;
        this.mode = mode;
        this.actionName = actionName;
        this.actionClass = actionClass;
        this.jar = jar;
        this.sparkOpts = sparkOpts;
    }

    public String getResourceManager() {
        return this.attributes.getResourceManager();
    }

    public String getNameNode() {
        return this.attributes.getNameNode();
    }

    public Prepare getPrepare() {
        return this.attributes.getPrepare();
    }

    public Launcher getLauncher() {
        return this.attributes.getLauncher();
    }

    public List<String> getJobXmls() {
        return this.attributes.getJobXmls();
    }

    public String getConfigProperty(String property) {
        return this.attributes.getConfiguration().get(property);
    }

    public Map<String, String> getConfiguration() {
        return this.attributes.getConfiguration();
    }

    public String getMaster() {
        return this.master;
    }

    public String getMode() {
        return this.mode;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public String getJar() {
        return this.jar;
    }

    public String getSparkOpts() {
        return this.sparkOpts;
    }

    public List<String> getArgs() {
        return this.attributes.getArgs();
    }

    public List<String> getFiles() {
        return this.attributes.getFiles();
    }

    public List<String> getArchives() {
        return this.attributes.getArchives();
    }

    @Override
    public ActionAttributes getAttributes() {
        return this.attributes;
    }
}

