/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Delete;
import org.apache.oozie.fluentjob.api.action.Mkdir;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrepareBuilder
implements Builder<Prepare> {
    private final ImmutableList.Builder<Delete> deletes = new ImmutableList.Builder();
    private final ImmutableList.Builder<Mkdir> mkdirs = new ImmutableList.Builder();

    public PrepareBuilder withDelete(String path) {
        return this.withDelete(path, null);
    }

    public PrepareBuilder withDelete(String path, Boolean skipTrash) {
        this.deletes.add((Object)new Delete(path, skipTrash));
        return this;
    }

    public PrepareBuilder withMkdir(String path) {
        this.mkdirs.add((Object)new Mkdir(path));
        return this;
    }

    @Override
    public Prepare build() {
        return new Prepare((ImmutableList<Delete>)this.deletes.build(), (ImmutableList<Mkdir>)this.mkdirs.build());
    }
}

