/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.ActionAttributes;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JavaAction
extends Node {
    private final ActionAttributes attributes;
    private final String mainClass;
    private final String javaOptsString;
    private final ImmutableList<String> javaOpts;

    JavaAction(Node.ConstructionData constructionData, ActionAttributes attributes, String mainClass, String javaOptsString, ImmutableList<String> javaOpts) {
        super(constructionData);
        this.attributes = attributes;
        this.mainClass = mainClass;
        this.javaOptsString = javaOptsString;
        this.javaOpts = javaOpts;
    }

    public String getResourceManager() {
        return this.attributes.getResourceManager();
    }

    public String getNameNode() {
        return this.attributes.getNameNode();
    }

    public Prepare getPrepare() {
        return this.attributes.getPrepare();
    }

    public Launcher getLauncher() {
        return this.attributes.getLauncher();
    }

    public List<String> getJobXmls() {
        return this.attributes.getJobXmls();
    }

    public String getConfigProperty(String property) {
        return this.attributes.getConfiguration().get(property);
    }

    public Map<String, String> getConfiguration() {
        return this.attributes.getConfiguration();
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getJavaOptsString() {
        return this.javaOptsString;
    }

    public List<String> getJavaOpts() {
        return this.javaOpts;
    }

    public List<String> getArgs() {
        return this.attributes.getArgs();
    }

    public List<String> getFiles() {
        return this.attributes.getFiles();
    }

    public List<String> getArchives() {
        return this.attributes.getArchives();
    }

    public boolean isCaptureOutput() {
        return this.attributes.isCaptureOutput();
    }

    ActionAttributes getAttributes() {
        return this.attributes;
    }
}

