/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.EmailAction;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EmailActionBuilder
extends NodeBuilderBaseImpl<EmailActionBuilder>
implements Builder<EmailAction> {
    private final ModifyOnce<String> to;
    private final ModifyOnce<String> cc;
    private final ModifyOnce<String> bcc;
    private final ModifyOnce<String> subject;
    private final ModifyOnce<String> body;
    private final ModifyOnce<String> contentType;
    private final ModifyOnce<String> attachment;

    public static EmailActionBuilder create() {
        ModifyOnce<String> to = new ModifyOnce<String>();
        ModifyOnce<String> cc = new ModifyOnce<String>();
        ModifyOnce<String> bcc = new ModifyOnce<String>();
        ModifyOnce<String> subject = new ModifyOnce<String>();
        ModifyOnce<String> body = new ModifyOnce<String>();
        ModifyOnce<String> contentType = new ModifyOnce<String>();
        ModifyOnce<String> attachment = new ModifyOnce<String>();
        return new EmailActionBuilder(null, to, cc, bcc, subject, body, contentType, attachment);
    }

    public static EmailActionBuilder createFromExistingAction(EmailAction action) {
        ModifyOnce<String> to = new ModifyOnce<String>(action.getRecipient());
        ModifyOnce<String> cc = new ModifyOnce<String>(action.getCc());
        ModifyOnce<String> bcc = new ModifyOnce<String>(action.getBcc());
        ModifyOnce<String> subject = new ModifyOnce<String>(action.getSubject());
        ModifyOnce<String> body = new ModifyOnce<String>(action.getBody());
        ModifyOnce<String> contentType = new ModifyOnce<String>(action.getContentType());
        ModifyOnce<String> attachment = new ModifyOnce<String>(action.getAttachment());
        return new EmailActionBuilder(action, to, cc, bcc, subject, body, contentType, attachment);
    }

    public static EmailActionBuilder createFromExistingAction(Node action) {
        ModifyOnce<String> to = new ModifyOnce<String>();
        ModifyOnce<String> cc = new ModifyOnce<String>();
        ModifyOnce<String> bcc = new ModifyOnce<String>();
        ModifyOnce<String> subject = new ModifyOnce<String>();
        ModifyOnce<String> body = new ModifyOnce<String>();
        ModifyOnce<String> contentType = new ModifyOnce<String>();
        ModifyOnce<String> attachment = new ModifyOnce<String>();
        return new EmailActionBuilder(action, to, cc, bcc, subject, body, contentType, attachment);
    }

    EmailActionBuilder(Node action, ModifyOnce<String> to, ModifyOnce<String> cc, ModifyOnce<String> bcc, ModifyOnce<String> subject, ModifyOnce<String> body, ModifyOnce<String> contentType, ModifyOnce<String> attachment) {
        super(action);
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = body;
        this.contentType = contentType;
        this.attachment = attachment;
    }

    public EmailActionBuilder withRecipient(String to) {
        this.to.set(to);
        return this;
    }

    public EmailActionBuilder withCc(String cc) {
        this.cc.set(cc);
        return this;
    }

    public EmailActionBuilder withBcc(String bcc) {
        this.bcc.set(bcc);
        return this;
    }

    public EmailActionBuilder withSubject(String subject) {
        this.subject.set(subject);
        return this;
    }

    public EmailActionBuilder withBody(String body) {
        this.body.set(body);
        return this;
    }

    public EmailActionBuilder withContentType(String contentType) {
        this.contentType.set(contentType);
        return this;
    }

    public EmailActionBuilder withAttachment(String attachment) {
        this.attachment.set(attachment);
        return this;
    }

    @Override
    public EmailAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        EmailAction instance = new EmailAction(constructionData, this.to.get(), this.cc.get(), this.bcc.get(), this.subject.get(), this.body.get(), this.contentType.get(), this.attachment.get());
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected EmailActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

