/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.utils;

import com.aliyun.dataworks_public20200518.Client;
import com.aliyun.dataworks_public20200518.models.CreateImportMigrationAdvanceRequest;
import com.aliyun.dataworks_public20200518.models.CreateImportMigrationResponse;
import com.aliyun.dataworks_public20200518.models.GetMigrationProcessRequest;
import com.aliyun.dataworks_public20200518.models.GetMigrationProcessResponse;
import com.aliyun.dataworks_public20200518.models.GetMigrationProcessResponseBody;
import com.aliyun.dataworks_public20200518.models.GetMigrationSummaryRequest;
import com.aliyun.dataworks_public20200518.models.GetMigrationSummaryResponse;
import com.aliyun.dataworks_public20200518.models.GetMigrationSummaryResponseBody;
import com.aliyun.dataworks_public20200518.models.ListMigrationObjectsRequest;
import com.aliyun.dataworks_public20200518.models.ListMigrationObjectsResponse;
import com.aliyun.dataworks_public20200518.models.ListMigrationObjectsResponseBody;
import com.aliyun.dataworks_public20200518.models.StartMigrationRequest;
import com.aliyun.dataworks_public20200518.models.StartMigrationResponse;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.assistant.module.DwAssistantItemType;
import com.aliyun.migration.workflow.migration.assistant.module.DwAssistantStatusType;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwAssistantClient {
    private static final Logger log = LoggerFactory.getLogger(DwAssistantClient.class);
    private Client client = null;
    private Map<Long, String> processStatus = new HashMap<Long, String>();
    private HashSet<Long> processInActive = new HashSet();
    private HashSet<Long> processFailed = new HashSet();
    private HashSet<Long> processSuccess = new HashSet();
    private Map<Long, String> migrationTaskIdProjectIdMap = new HashMap<Long, String>();
    private String endpointRegion;
    private Map<Long, StatisticOp> importDetail = new HashMap<Long, StatisticOp>();

    public DwAssistantClient(String endpoint, String accessKeyId, String accessKeySecret) {
        this.init(endpoint, accessKeyId, accessKeySecret);
        this.endpointRegion = endpoint.substring(endpoint.indexOf(".") + 1, endpoint.length());
        this.endpointRegion = this.endpointRegion.substring(0, this.endpointRegion.indexOf("."));
    }

    public void init(String endpoint, String accessKeyId, String accessKeySecret) {
        try {
            this.client = this.createClient(endpoint, accessKeyId, accessKeySecret);
        }
        catch (Exception e) {
            log.error("init client failed: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Client createClient(String endpoint, String accessKeyId, String accessKeySecret) throws Exception {
        Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
        config.endpoint = endpoint;
        return new Client(config);
    }

    public Long importFiles(String filePath, String commitRule, String projectId) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        CreateImportMigrationAdvanceRequest request = new CreateImportMigrationAdvanceRequest();
        File f = new File(filePath);
        request.setName(f.getName() + "_byBwm_" + System.currentTimeMillis());
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setCommitRule(commitRule);
        request.setPackageType("DATAWORKS_MODEL");
        request.setResourceGroupMap("{\n    \"SCHEDULER_RESOURCE_GROUP\": {\n        \"NOT_REAL\": \"NOT_REAL\"\n    },\n    \"DI_RESOURCE_GROUP\": {\n        \"NOT_REAL\": \"NOT_REAL\"\n    }\n}");
        request.setWorkspaceMap("{\"NOT_REAL\": \"NOT_REAL\"}\n");
        request.setCalculateEngineMap("{\n    \"ODPS\": {\n        \"NOT_REAL\": \"NOT_REAL\"\n    },\n    \"EMR\": {\n        \"NOT_REAL\": \"NOT_REAL\"\n    },\n    \"HADOOP_CDH\": {\n        \"NOT_REAL\": \"NOT_REAL\"\n    },\n    \"HOLOGRES\": {\n        \"NOT_REAL\": \"NOT_REAL\"\n    }\n}");
        FileInputStream file = new FileInputStream(filePath);
        request.setPackageFileObject((InputStream)file);
        try {
            CreateImportMigrationResponse response = this.client.createImportMigrationAdvance(request, runtime);
            if (response.getBody().getSuccess().booleanValue()) {
                Long migrationId = response.getBody().getData();
                this.migrationTaskIdProjectIdMap.put(migrationId, projectId);
                if (this.startImportFiles(migrationId)) {
                    this.processStatus.put(migrationId, "RUNNING");
                    this.processInActive.add(migrationId);
                } else {
                    this.processStatus.put(migrationId, "FAILURE");
                    this.processFailed.add(migrationId);
                    log.info("One finish with FAILURE: {}", (Object)migrationId);
                    log.info("Import Report: http://migration-{}.data.aliyun.com/?defaultProjectId={}#/import/{}/report", new Object[]{this.endpointRegion, projectId, migrationId});
                }
                return migrationId;
            }
        }
        catch (TeaException error) {
            log.info("{}", (Object)error.getMessage());
            log.info("{}", error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info("{}", (Object)error.getMessage());
            log.info("{}", error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        return null;
    }

    public boolean startImportFiles(long migrationId) throws Exception {
        StartMigrationRequest request = new StartMigrationRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(this.migrationTaskIdProjectIdMap.get(migrationId))));
        request.setMigrationId(Long.valueOf(migrationId));
        try {
            StartMigrationResponse response = this.client.startMigration(request);
            return response.getBody().getData();
        }
        catch (TeaException error) {
            log.info("{}", (Object)error.getMessage());
            log.info("{}", error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info("{}", (Object)error.getMessage());
            log.info("{}", error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        return false;
    }

    public GetMigrationProcessResponseBody.GetMigrationProcessResponseBodyData getProcessById(long migrationId) throws Exception {
        GetMigrationProcessRequest request = new GetMigrationProcessRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(this.migrationTaskIdProjectIdMap.get(migrationId))));
        request.setMigrationId(Long.valueOf(migrationId));
        try {
            GetMigrationProcessResponse response = this.client.getMigrationProcess(request);
            GetMigrationProcessResponseBody.GetMigrationProcessResponseBodyData data = (GetMigrationProcessResponseBody.GetMigrationProcessResponseBodyData)response.getBody().getData().get(0);
            this.processStatus.put(migrationId, data.taskStatus);
            if (StringUtils.equals((CharSequence)data.taskStatus, (CharSequence)"FAILURE")) {
                this.processInActive.remove(migrationId);
                this.processFailed.add(migrationId);
                log.info("One finish with FAILURE: {}", (Object)migrationId);
            } else if (StringUtils.equals((CharSequence)data.taskStatus, (CharSequence)"SUCCESS")) {
                this.processInActive.remove(migrationId);
                this.processSuccess.add(migrationId);
                log.info("One finish with SUCCESS: {}", (Object)migrationId);
            }
            return data;
        }
        catch (TeaException error) {
            log.info("{}", (Object)error.getMessage());
            log.info("{}", error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info("{}", (Object)error.getMessage());
            log.info("{}", error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
        return null;
    }

    public GetMigrationSummaryResponseBody.GetMigrationSummaryResponseBodyData getProcessSummaryById(long migrationId) throws Exception {
        GetMigrationSummaryRequest request = new GetMigrationSummaryRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(this.migrationTaskIdProjectIdMap.get(migrationId))));
        request.setMigrationId(Long.valueOf(migrationId));
        try {
            GetMigrationSummaryResponse response = this.client.getMigrationSummary(request);
            GetMigrationSummaryResponseBody.GetMigrationSummaryResponseBodyData data = response.getBody().getData();
            this.processStatus.put(migrationId, data.getStatus());
            if (StringUtils.equals((CharSequence)data.getStatus(), (CharSequence)"IMPORT_ERROR") | StringUtils.equals((CharSequence)data.getStatus(), (CharSequence)"PARTIAL_SUCCESS") | StringUtils.equals((CharSequence)data.getStatus(), (CharSequence)"REVOKED")) {
                this.processInActive.remove(migrationId);
                this.processFailed.add(migrationId);
                log.info("One finish with {}: {}", (Object)data.getStatus(), (Object)migrationId);
                log.info("Import Report: http://migration-{}.data.aliyun.com/?defaultProjectId={}#/import/{}/report", new Object[]{this.endpointRegion, this.migrationTaskIdProjectIdMap.get(migrationId), migrationId});
            } else if (StringUtils.equals((CharSequence)data.getStatus(), (CharSequence)"IMPORT_SUCCESS")) {
                this.processInActive.remove(migrationId);
                this.processSuccess.add(migrationId);
                log.info("One finish with SUCCESS: {}", (Object)migrationId);
                log.info("Import Report: http://migration-{}.data.aliyun.com/?defaultProjectId={}#/import/{}/report", new Object[]{this.endpointRegion, this.migrationTaskIdProjectIdMap.get(migrationId), migrationId});
            }
            return data;
        }
        catch (Exception e) {
            log.info("\u8fc1\u79fb\u52a9\u624b\u5bfc\u5165\u9519\u8bef\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public Map<Long, StatisticOp> getImportDetail() {
        return this.importDetail;
    }

    public StatisticOp parseImportReport(long migrationId, GetMigrationSummaryResponseBody.GetMigrationSummaryResponseBodyDataSummary summary, StatisticOp statisticOp) {
        if (statisticOp == null) {
            statisticOp = new StatisticOp();
        }
        ArrayList<DwAssistantStatusType> checkTypes = new ArrayList<DwAssistantStatusType>();
        checkTypes.add(DwAssistantStatusType.of("failure"));
        for (DwAssistantStatusType checkType : checkTypes) {
            for (String itemTypeName : DwAssistantItemType.getTypelist()) {
                long count = (Long)((HashMap)summary.toMap().get(itemTypeName)).get(checkType.getCountName());
                if (count == 0L) continue;
                int pagesize = 10;
                int pageamount = (int)Math.ceil((double)count / (double)pagesize);
                for (int page = 1; page <= pageamount; ++page) {
                    ListMigrationObjectsRequest request = new ListMigrationObjectsRequest();
                    request.setProjectId(Long.valueOf(Long.parseLong(this.migrationTaskIdProjectIdMap.get(migrationId))));
                    request.setMigrationId(Long.valueOf(migrationId));
                    request.setItemType(itemTypeName);
                    request.setStatuses(checkType.getStatusName());
                    request.setPageNumber(Integer.valueOf(page));
                    request.setPageSize(Integer.valueOf(pagesize));
                    try {
                        ListMigrationObjectsResponse response = this.client.listMigrationObjects(request);
                        for (ListMigrationObjectsResponseBody.ListMigrationObjectsResponseBodyDataMigrations mgDetail : response.getBody().getData().getMigrations()) {
                            ((StatisticOp.StatisticIterm)statisticOp.toMap().get(DwAssistantItemType.of(itemTypeName).getPieceNameIntaskContext() + checkType.getPieceNameIntaskContext())).justAddOneMsgLog(mgDetail.getObjectId().toString(), mgDetail.getMessage());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.warn("ListMigrationObjectsRequest\u8bf7\u6c42\u4e0e\u89e3\u6790\u9047\u5230\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                    }
                }
            }
        }
        checkTypes = new ArrayList();
        checkTypes.add(DwAssistantStatusType.of("success"));
        checkTypes.add(DwAssistantStatusType.of("failure"));
        checkTypes.add(DwAssistantStatusType.of("total"));
        for (DwAssistantStatusType checkType : checkTypes) {
            for (String itemTypeName : DwAssistantItemType.getTypelist()) {
                int count = ((Long)((HashMap)summary.toMap().get(itemTypeName)).get(checkType.getCountName())).intValue();
                ((StatisticOp.StatisticIterm)statisticOp.toMap().get(DwAssistantItemType.of(itemTypeName).getPieceNameIntaskContext() + checkType.getPieceNameIntaskContext())).increment(count);
            }
        }
        return statisticOp;
    }

    public int refreshAllProcessStatus() throws Exception {
        Iterator<Long> itr = this.processInActive.iterator();
        while (itr.hasNext()) {
            this.getProcessSummaryById(itr.next());
        }
        log.info("In Process(AutoCheck): {}", (Object)this.processInActive.toString());
        return this.processInActive.size();
    }

    public void waitingForImportFinish() throws Exception {
        while (this.refreshAllProcessStatus() > 0) {
            Thread.sleep(30000L);
        }
        log.info("-----------IMPORT RESULT------------");
        log.info("Import Finish: total {}, success {}, fail {}", new Object[]{this.processSuccess.size() + this.processFailed.size(), this.processSuccess.size(), this.processFailed.size()});
        if (this.processFailed.size() > 0) {
            log.info("Fail list:");
            for (long migrationId : this.processFailed) {
                log.info("{}", (Object)migrationId);
            }
        }
        log.info("-----------IMPORT FINISH------------");
    }

    public void oneClickImport(Map<String, List<String>> filePath, String commitRule) throws Exception {
        filePath.forEach((projectId, path) -> path.forEach(p -> {
            try {
                this.importFiles((String)p, commitRule, (String)projectId);
            }
            catch (Exception e) {
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.RUNTIME_ERROR);
            }
        }));
    }

    public void importFilesOneByOne(Map<String, List<String>> filePath, String commitRule) {
        filePath.forEach((projectId, path) -> path.forEach(p -> {
            try {
                this.importFiles((String)p, commitRule, (String)projectId);
            }
            catch (Exception e) {
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.RUNTIME_ERROR);
            }
        }));
    }
}

