/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.module;

import com.aliyun.migration.api.context.StatisticOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DwAssistantItemType {
    SCHEDULED_NODE("SCHEDULED_NODE", "workflowNode", StatisticOp.StatisticType.WORKFLOWNODE),
    MANUAL_NODE("MANUAL_NODE", "workflowNode", StatisticOp.StatisticType.WORKFLOWNODE),
    RESOURCE("RESOURCE", "workflowResource", StatisticOp.StatisticType.RESOURCE),
    FUNCTION("FUNCTION", "workflowFun", StatisticOp.StatisticType.FUNCTION),
    COMPONENT("COMPONENT", "workflowComp", StatisticOp.StatisticType.COMPONENT),
    TABLE("TABLE", "workflowTable", StatisticOp.StatisticType.TABLE),
    DATASOURCE("DATASOURCE", "workflowDataSoc", StatisticOp.StatisticType.DATASOURCE),
    AD_HOC_QUERY("AD_HOC_QUERY", "workflowAdHoc", StatisticOp.StatisticType.AD_HOC_QUERY),
    DATA_SERVICE("DATA_SERVICE", "workflowDataSvc", StatisticOp.StatisticType.DATA_SERVICE),
    DQC("DQC", "workflowDQC", StatisticOp.StatisticType.DQC);

    private final String name;
    private final String pieceNameIntaskContext;
    private final StatisticOp.StatisticType statisticType;
    private static final Map<String, DwAssistantItemType> COMMAND_TYPE_MAP;

    private DwAssistantItemType(String name, String pieceNameIntaskContext, StatisticOp.StatisticType statisticType) {
        this.name = name;
        this.pieceNameIntaskContext = pieceNameIntaskContext;
        this.statisticType = statisticType;
    }

    public String getName() {
        return this.name;
    }

    public String getPieceNameIntaskContext() {
        return this.pieceNameIntaskContext;
    }

    public StatisticOp.StatisticType getStatisticType() {
        return this.statisticType;
    }

    public static DwAssistantItemType of(String name) {
        return COMMAND_TYPE_MAP.get(name);
    }

    public static List<String> getTypelist() {
        ArrayList<String> typeList = new ArrayList<String>();
        for (DwAssistantItemType itemType : DwAssistantItemType.values()) {
            typeList.add(itemType.getName());
        }
        return typeList;
    }

    static {
        COMMAND_TYPE_MAP = new HashMap<String, DwAssistantItemType>();
        for (DwAssistantItemType oozieNodeType : DwAssistantItemType.values()) {
            COMMAND_TYPE_MAP.put(oozieNodeType.name, oozieNodeType);
        }
    }
}

