/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.assistant.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.assistant.converter.DINodeConverter;
import com.aliyun.migration.workflow.migration.assistant.converter.DefaultNodeConverter;
import com.aliyun.migration.workflow.migration.assistant.converter.EMRNodeConverter;
import com.aliyun.migration.workflow.migration.assistant.converter.GeneralNodeConverter;
import com.aliyun.migration.workflow.migration.assistant.converter.OdpsNodeConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(DwConverterFactory.class);

    public static AbstractDwNodeConverter buildConvert(String type, BwmConfiguration bwmConfiguration) {
        if (StringUtils.isBlank((String)type)) {
            log.error("type is null {}", (Object)type);
            return new DefaultNodeConverter(bwmConfiguration);
        }
        CodeProgramType resType = null;
        for (CodeProgramType nodeType : CodeProgramType.values()) {
            if (!(type.equals(String.valueOf(nodeType.getCode())) | type.equals(String.valueOf(nodeType.getName())))) continue;
            resType = nodeType;
            break;
        }
        if (Objects.isNull(resType)) {
            log.info("type not supported: {}", (Object)type);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.BWM_TYPE_NOT_SUPPORTED_ERROR);
        }
        AbstractDwNodeConverter converter = switch (resType) {
            case CodeProgramType.SHELL, CodeProgramType.DIDE_SHELL, CodeProgramType.VIRTUAL, CodeProgramType.CONTROLLER_BRANCH, CodeProgramType.CONTROLLER_JOIN -> new GeneralNodeConverter();
            case CodeProgramType.ODPS_SQL, CodeProgramType.ODPS_MR, CodeProgramType.ODPS_SPARK, CodeProgramType.ODPS_SPARK_SQL, CodeProgramType.ODPS_PYTHON, CodeProgramType.ODPS_SCRIPT, CodeProgramType.PYODPS, CodeProgramType.PYODPS3 -> new OdpsNodeConverter();
            case CodeProgramType.EMR_SHELL, CodeProgramType.EMR_HIVE, CodeProgramType.EMR_SPARK, CodeProgramType.EMR_SPARK_SQL, CodeProgramType.EMR_MR, CodeProgramType.EMR_PRESTO, CodeProgramType.EMR_IMPALA, CodeProgramType.EMR_SPARK_STREAMING, CodeProgramType.EMR_TRINO -> new EMRNodeConverter();
            case CodeProgramType.DI -> new DINodeConverter();
            default -> new DefaultNodeConverter();
        };
        converter.setConf(bwmConfiguration);
        return converter;
    }
}

