/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.propertydescriptor;

import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.FieldMap;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.propertydescriptor.DozerPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.JavaBeanPropertyDescriptor;

public class XmlBeanPropertyDescriptor
implements DozerPropertyDescriptor {
    private static final String IS_SET_PREFIX = "set";
    private static final String DOT = ".";
    private final JavaBeanPropertyDescriptor fieldPropertyDescriptor;
    private final JavaBeanPropertyDescriptor isSetFieldPropertyDescriptor;

    public XmlBeanPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, BeanContainer beanContainer, DestBeanCreator destBeanCreator) {
        this.fieldPropertyDescriptor = new JavaBeanPropertyDescriptor(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
        this.isSetFieldPropertyDescriptor = new JavaBeanPropertyDescriptor(clazz, this.getIsSetFieldName(fieldName), isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
    }

    @Override
    public Class<?> getPropertyType() {
        return this.fieldPropertyDescriptor.getPropertyType();
    }

    @Override
    public Object getPropertyValue(Object bean) {
        return this.isFieldSet(bean) ? this.fieldPropertyDescriptor.getPropertyValue(bean) : null;
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        this.fieldPropertyDescriptor.setPropertyValue(bean, value, fieldMap);
    }

    private boolean isFieldSet(Object bean) {
        try {
            Boolean isSetField = (Boolean)this.isSetFieldPropertyDescriptor.getPropertyValue(bean);
            return isSetField;
        }
        catch (Throwable e) {
            return true;
        }
    }

    private String getIsSetFieldName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        int lastDotIndex = fieldName.lastIndexOf(DOT);
        if (lastDotIndex < 0 || lastDotIndex == fieldName.length() - 1) {
            return IS_SET_PREFIX + fieldName;
        }
        return fieldName.substring(0, lastDotIndex + 1) + IS_SET_PREFIX + fieldName.substring(lastDotIndex + 1);
    }

    @Override
    public Class<?> genericType() {
        return null;
    }
}

