/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.propertydescriptor;

import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.propertydescriptor.JavaBeanPropertyDescriptor;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.core.util.ReflectionUtils;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;

public class CustomGetSetPropertyDescriptor
extends JavaBeanPropertyDescriptor {
    private final String customSetMethod;
    private final String customGetMethod;
    private SoftReference<Method> writeMethod;
    private SoftReference<Method> readMethod;

    public CustomGetSetPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, String customSetMethod, String customGetMethod, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, BeanContainer beanContainer, DestBeanCreator destBeanCreator) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
        this.customSetMethod = customSetMethod;
        this.customGetMethod = customGetMethod;
    }

    @Override
    public Method getWriteMethod() throws NoSuchMethodException {
        if (this.writeMethod == null || this.writeMethod.get() == null) {
            if (this.customSetMethod != null && !MappingUtils.isDeepMapping(this.fieldName)) {
                Method method = ReflectionUtils.findAMethod(this.clazz, this.customSetMethod, this.beanContainer);
                this.writeMethod = new SoftReference<Method>(method);
            } else {
                return super.getWriteMethod();
            }
        }
        return this.writeMethod.get();
    }

    @Override
    protected Method getReadMethod() throws NoSuchMethodException {
        if (this.readMethod == null || this.readMethod.get() == null) {
            if (this.customGetMethod != null) {
                Method method = ReflectionUtils.findAMethod(this.clazz, this.customGetMethod, this.beanContainer);
                this.readMethod = new SoftReference<Method>(method);
            } else {
                return super.getReadMethod();
            }
        }
        return this.readMethod.get();
    }

    @Override
    protected String getSetMethodName() throws NoSuchMethodException {
        return this.customSetMethod != null ? this.customSetMethod : super.getSetMethodName();
    }

    @Override
    protected boolean isCustomSetMethod() {
        return this.customSetMethod != null;
    }
}

