/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.factory;

import com.github.dozermapper.core.BeanFactory;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.core.util.ReflectionUtils;
import java.lang.reflect.Method;

public class XMLBeanFactory
implements BeanFactory {
    private static final Class<?>[] emptyArgList = new Class[0];

    @Override
    public Object createBean(Object srcObj, Class<?> srcObjClass, String beanId, BeanContainer beanContainer) {
        Class<?> destClass = MappingUtils.loadClass(beanId, beanContainer);
        Class<?>[] innerClasses = destClass.getClasses();
        Class<?> factory = null;
        for (Class<?> innerClass : innerClasses) {
            if (!innerClass.getName().endsWith("Factory")) continue;
            factory = innerClass;
        }
        if (factory == null) {
            MappingUtils.throwMappingException("Factory class of Bean of type " + beanId + " not found.");
        }
        Method newInstanceMethod = null;
        try {
            newInstanceMethod = ReflectionUtils.getMethod(factory, "newInstance", emptyArgList);
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        Object result = ReflectionUtils.invoke(newInstanceMethod, null, emptyArgList);
        return result;
    }
}

