/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.workflow;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.workflow.ConfigurationEntry;
import org.apache.oozie.fluentjob.api.workflow.Credential;
import org.apache.oozie.fluentjob.api.workflow.Credentials;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CredentialsBuilder
implements Builder<Credentials> {
    private final ImmutableList.Builder<Credential> credentials;

    public static CredentialsBuilder create() {
        return new CredentialsBuilder((ImmutableList.Builder<Credential>)new ImmutableList.Builder());
    }

    public static CredentialsBuilder createFromExisting(Credentials credentials) {
        return new CredentialsBuilder((ImmutableList.Builder<Credential>)new ImmutableList.Builder().addAll(credentials.getCredentials()));
    }

    CredentialsBuilder(ImmutableList.Builder<Credential> credentials) {
        this.credentials = credentials;
    }

    public CredentialsBuilder withCredential(String name, String value) {
        this.credentials.add((Object)new Credential(name, value, (ImmutableList<ConfigurationEntry>)ImmutableList.of()));
        return this;
    }

    public CredentialsBuilder withCredential(String name, String type, List<ConfigurationEntry> configurationEntries) {
        this.credentials.add((Object)new Credential(name, type, (ImmutableList<ConfigurationEntry>)ImmutableList.copyOf(configurationEntries)));
        return this;
    }

    public CredentialsBuilder withCredential(Credential credential) {
        this.credentials.add((Object)credential);
        return this;
    }

    @Override
    public Credentials build() {
        return new Credentials((ImmutableList<Credential>)this.credentials.build());
    }
}

