/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import java.util.Iterator;
import java.util.Map;
import org.apache.oozie.fluentjob.api.generated.workflow.CONFIGURATION;
import org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory;

public class MapToConfigurationPropertyConverter
extends DozerConverter<Map, CONFIGURATION> {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public MapToConfigurationPropertyConverter() {
        super(Map.class, CONFIGURATION.class);
    }

    public CONFIGURATION convertTo(Map source, CONFIGURATION destination) {
        destination = this.ensureConfiguration(destination);
        Iterator iterator = source.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            CONFIGURATION.Property property = this.createProperty(key, value);
            destination.getProperty().add(property);
        }
        return destination;
    }

    private CONFIGURATION ensureConfiguration(CONFIGURATION destination) {
        if (destination == null) {
            destination = OBJECT_FACTORY.createCONFIGURATION();
        }
        return destination;
    }

    private CONFIGURATION.Property createProperty(String key, String value) {
        CONFIGURATION.Property property = OBJECT_FACTORY.createCONFIGURATIONProperty();
        property.setName(key);
        property.setValue(value);
        return property;
    }

    public Map convertFrom(CONFIGURATION source, Map destination) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }
}

