/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.ActionAttributes;
import org.apache.oozie.fluentjob.api.action.HasAttributes;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GitAction
extends Node
implements HasAttributes {
    protected final ActionAttributes attributes;
    protected final String gitUri;
    protected final String branch;
    protected final String keyPath;
    protected final String destinationUri;

    GitAction(Node.ConstructionData constructionData, ActionAttributes attributes, String gitUri, String branch, String keyPath, String destinationUri) {
        super(constructionData);
        this.attributes = attributes;
        this.gitUri = gitUri;
        this.branch = branch;
        this.keyPath = keyPath;
        this.destinationUri = destinationUri;
    }

    public String getResourceManager() {
        return this.attributes.getResourceManager();
    }

    public String getNameNode() {
        return this.attributes.getNameNode();
    }

    public Prepare getPrepare() {
        return this.attributes.getPrepare();
    }

    public String getConfigProperty(String property) {
        return this.attributes.getConfiguration().get(property);
    }

    public Map<String, String> getConfiguration() {
        return this.attributes.getConfiguration();
    }

    public String getGitUri() {
        return this.gitUri;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    @Override
    public ActionAttributes getAttributes() {
        return this.attributes;
    }
}

