/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Node;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ErrorHandler {
    private final Node handlerNode;

    public static ErrorHandler buildAsErrorHandler(Builder<? extends Node> builder) {
        Node handlerNode = builder.build();
        return new ErrorHandler(handlerNode);
    }

    private ErrorHandler(Node handlerNode) {
        boolean hasParents = !handlerNode.getAllParents().isEmpty();
        boolean hasChildren = !handlerNode.getAllChildren().isEmpty();
        Preconditions.checkState((!hasParents && !hasChildren ? 1 : 0) != 0, (Object)"Error handler nodes cannot have parents or children.");
        this.handlerNode = handlerNode;
    }

    public String getName() {
        return this.handlerNode.getName();
    }

    public Node getHandlerNode() {
        return this.handlerNode;
    }
}

