/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ChFSBase;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ChFSBaseBuilder<B extends ChFSBaseBuilder<B>> {
    private final ModifyOnce<Boolean> recursive = new ModifyOnce<Boolean>(false);
    private final ModifyOnce<String> path = new ModifyOnce();
    private final ModifyOnce<String> dirFiles = new ModifyOnce<String>("true");

    public B setRecursive() {
        this.recursive.set(true);
        return this.ensureRuntimeSelfReference();
    }

    public B setNonRecursive() {
        this.recursive.set(false);
        return this.ensureRuntimeSelfReference();
    }

    public B withPath(String path) {
        this.path.set(path);
        return this.ensureRuntimeSelfReference();
    }

    public B setDirFiles(boolean dirFiles) {
        this.dirFiles.set(Boolean.toString(dirFiles));
        return this.ensureRuntimeSelfReference();
    }

    final B ensureRuntimeSelfReference() {
        B concrete = this.getRuntimeSelfReference();
        if (concrete != this) {
            throw new IllegalStateException("The builder type B doesn't extend ChFSBaseBuilder<B>.");
        }
        return concrete;
    }

    protected ChFSBase.ConstructionData getConstructionData() {
        return new ChFSBase.ConstructionData(this.recursive.get(), this.path.get(), this.dirFiles.get());
    }

    protected abstract B getRuntimeSelfReference();
}

