/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributes;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Chgrp;
import org.apache.oozie.fluentjob.api.action.Chmod;
import org.apache.oozie.fluentjob.api.action.Delete;
import org.apache.oozie.fluentjob.api.action.HasAttributes;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Mkdir;
import org.apache.oozie.fluentjob.api.action.Move;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.Pipes;
import org.apache.oozie.fluentjob.api.action.Prepare;
import org.apache.oozie.fluentjob.api.action.Streaming;
import org.apache.oozie.fluentjob.api.action.Touchz;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ActionAttributesBuilder
implements Builder<ActionAttributes> {
    private final ModifyOnce<String> resourceManager;
    private final ModifyOnce<String> nameNode;
    private final ModifyOnce<Prepare> prepare;
    private final ModifyOnce<Streaming> streaming;
    private final ModifyOnce<Pipes> pipes;
    private final List<String> jobXmls;
    private final Map<String, ModifyOnce<String>> configuration;
    private final ModifyOnce<String> configClass;
    private final List<String> files;
    private final List<String> archives;
    private final List<Delete> deletes;
    private final List<Mkdir> mkdirs;
    private final List<Move> moves;
    private final List<Chmod> chmods;
    private final List<Touchz> touchzs;
    private final List<Chgrp> chgrps;
    private final ModifyOnce<String> javaOpts;
    private final List<String> args;
    private final ModifyOnce<Launcher> launcher;
    private final ModifyOnce<Boolean> captureOutput;

    public static ActionAttributesBuilder create() {
        ModifyOnce<String> resourceManager = new ModifyOnce<String>();
        ModifyOnce<String> nameNode = new ModifyOnce<String>();
        ModifyOnce<Prepare> prepare = new ModifyOnce<Prepare>();
        ModifyOnce<Streaming> streaming = new ModifyOnce<Streaming>();
        ModifyOnce<Pipes> pipes = new ModifyOnce<Pipes>();
        ArrayList<String> jobXmls = new ArrayList<String>();
        LinkedHashMap<String, ModifyOnce<String>> configuration = new LinkedHashMap<String, ModifyOnce<String>>();
        ModifyOnce<String> configClass = new ModifyOnce<String>();
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> archives = new ArrayList<String>();
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        ArrayList<Mkdir> mkdirs = new ArrayList<Mkdir>();
        ArrayList<Move> moves = new ArrayList<Move>();
        ArrayList<Chmod> chmods = new ArrayList<Chmod>();
        ArrayList<Touchz> touchzs = new ArrayList<Touchz>();
        ArrayList<Chgrp> chgrps = new ArrayList<Chgrp>();
        ModifyOnce<String> javaOpts = new ModifyOnce<String>();
        ArrayList<String> args = new ArrayList<String>();
        ModifyOnce<Launcher> launcher = new ModifyOnce<Launcher>();
        ModifyOnce<Boolean> captureOutput = new ModifyOnce<Boolean>();
        return new ActionAttributesBuilder(resourceManager, prepare, streaming, pipes, jobXmls, configuration, configClass, files, archives, deletes, mkdirs, moves, chmods, touchzs, chgrps, javaOpts, args, nameNode, launcher, captureOutput);
    }

    public static ActionAttributesBuilder createFromExisting(ActionAttributes attributes) {
        ModifyOnce<String> resourceManager = new ModifyOnce<String>(attributes.getResourceManager());
        ModifyOnce<String> nameNode = new ModifyOnce<String>(attributes.getNameNode());
        ModifyOnce<Prepare> prepare = new ModifyOnce<Prepare>(attributes.getPrepare());
        ModifyOnce<Streaming> streaming = new ModifyOnce<Streaming>(attributes.getStreaming());
        ModifyOnce<Pipes> pipes = new ModifyOnce<Pipes>(attributes.getPipes());
        ArrayList<String> jobXmls = new ArrayList<String>(attributes.getJobXmls());
        Map<String, ModifyOnce<String>> configuration = ActionAttributesBuilder.convertToModifyOnceMap(attributes.getConfiguration());
        ModifyOnce<String> configClass = new ModifyOnce<String>(attributes.getConfigClass());
        ArrayList<String> files = new ArrayList<String>(attributes.getFiles());
        ArrayList<String> archives = new ArrayList<String>(attributes.getArchives());
        ArrayList<Delete> deletes = new ArrayList<Delete>(attributes.getDeletes());
        ArrayList<Mkdir> mkdirs = new ArrayList<Mkdir>(attributes.getMkdirs());
        ArrayList<Move> moves = new ArrayList<Move>(attributes.getMoves());
        ArrayList<Chmod> chmods = new ArrayList<Chmod>(attributes.getChmods());
        ArrayList<Touchz> touchzs = new ArrayList<Touchz>(attributes.getTouchzs());
        ArrayList<Chgrp> chgrps = new ArrayList<Chgrp>(attributes.getChgrps());
        ModifyOnce<String> javaOpts = new ModifyOnce<String>(attributes.getJavaOpts());
        ArrayList<String> args = new ArrayList<String>(attributes.getArgs());
        ModifyOnce<Launcher> launcher = new ModifyOnce<Launcher>(attributes.getLauncher());
        ModifyOnce<Boolean> captureOutput = new ModifyOnce<Boolean>(attributes.isCaptureOutput());
        return new ActionAttributesBuilder(resourceManager, prepare, streaming, pipes, jobXmls, configuration, configClass, files, archives, deletes, mkdirs, moves, chmods, touchzs, chgrps, javaOpts, args, nameNode, launcher, captureOutput);
    }

    public static ActionAttributesBuilder createFromAction(Node action) {
        if (HasAttributes.class.isAssignableFrom(action.getClass()) && action instanceof HasAttributes) {
            return ActionAttributesBuilder.createFromExisting(((HasAttributes)((Object)action)).getAttributes());
        }
        return ActionAttributesBuilder.create();
    }

    private ActionAttributesBuilder(ModifyOnce<String> resourceManager, ModifyOnce<Prepare> prepare, ModifyOnce<Streaming> streaming, ModifyOnce<Pipes> pipes, List<String> jobXmls, Map<String, ModifyOnce<String>> configuration, ModifyOnce<String> configClass, List<String> files, List<String> archives, List<Delete> deletes, List<Mkdir> mkdirs, List<Move> moves, List<Chmod> chmods, List<Touchz> touchzs, List<Chgrp> chgrps, ModifyOnce<String> javaOpts, List<String> args, ModifyOnce<String> nameNode, ModifyOnce<Launcher> launcher, ModifyOnce<Boolean> captureOutput) {
        this.nameNode = nameNode;
        this.prepare = prepare;
        this.streaming = streaming;
        this.pipes = pipes;
        this.jobXmls = jobXmls;
        this.configuration = configuration;
        this.configClass = configClass;
        this.files = files;
        this.archives = archives;
        this.deletes = deletes;
        this.mkdirs = mkdirs;
        this.moves = moves;
        this.chmods = chmods;
        this.touchzs = touchzs;
        this.chgrps = chgrps;
        this.javaOpts = javaOpts;
        this.args = args;
        this.resourceManager = resourceManager;
        this.launcher = launcher;
        this.captureOutput = captureOutput;
    }

    public void withResourceManager(String resourceManager) {
        this.resourceManager.set(resourceManager);
    }

    public void withNameNode(String nameNode) {
        this.nameNode.set(nameNode);
    }

    void withPrepare(Prepare prepare) {
        this.prepare.set(prepare);
    }

    void withStreaming(Streaming streaming) {
        this.streaming.set(streaming);
    }

    void withPipes(Pipes pipes) {
        this.pipes.set(pipes);
    }

    public void withJobXml(String jobXml) {
        this.jobXmls.add(jobXml);
    }

    public void withoutJobXml(String jobXml) {
        this.jobXmls.remove(jobXml);
    }

    public void clearJobXmls() {
        this.jobXmls.clear();
    }

    public void withConfigProperty(String key, String value) {
        ModifyOnce<String> mappedValue = this.configuration.get(key);
        if (mappedValue == null) {
            mappedValue = new ModifyOnce<String>(value);
            this.configuration.put(key, mappedValue);
        }
        mappedValue.set(value);
    }

    void withConfigClass(String configClass) {
        this.configClass.set(configClass);
    }

    void withFile(String file) {
        this.files.add(file);
    }

    void withoutFile(String file) {
        this.files.remove(file);
    }

    void clearFiles() {
        this.files.clear();
    }

    void withArchive(String archive) {
        this.archives.add(archive);
    }

    void withoutArchive(String archive) {
        this.archives.remove(archive);
    }

    void clearArchives() {
        this.archives.clear();
    }

    void withDelete(Delete delete) {
        this.deletes.add(delete);
    }

    void withoutDelete(Delete delete) {
        this.deletes.remove(delete);
    }

    void clearDeletes() {
        this.deletes.clear();
    }

    void withMkdir(Mkdir mkdir) {
        this.mkdirs.add(mkdir);
    }

    void withoutMkdir(Mkdir mkdir) {
        this.mkdirs.remove(mkdir);
    }

    void clearMkdirs() {
        this.mkdirs.clear();
    }

    void withMove(Move move) {
        this.moves.add(move);
    }

    void withoutMove(Move move) {
        this.moves.remove(move);
    }

    void clearMoves() {
        this.moves.clear();
    }

    void withChmod(Chmod chmod) {
        this.chmods.add(chmod);
    }

    void withoutChmod(Chmod chmod) {
        this.chmods.remove(chmod);
    }

    void clearChmods() {
        this.chmods.clear();
    }

    void withTouchz(Touchz touchz) {
        this.touchzs.add(touchz);
    }

    void withoutTouchz(Touchz touchz) {
        this.touchzs.remove(touchz);
    }

    void clearTouchzs() {
        this.touchzs.clear();
    }

    void withChgrp(Chgrp chgrp) {
        this.chgrps.add(chgrp);
    }

    void withoutChgrp(Chgrp chgrp) {
        this.chgrps.remove(chgrp);
    }

    void clearChgrps() {
        this.chgrps.clear();
    }

    void withJavaOpts(String javaOpts) {
        this.javaOpts.set(javaOpts);
    }

    void withArg(String arg) {
        this.args.add(arg);
    }

    void withoutArg(String arg) {
        this.args.remove(arg);
    }

    void clearArgs() {
        this.args.clear();
    }

    public void withLauncher(Launcher launcher) {
        this.launcher.set(launcher);
    }

    void withCaptureOutput(Boolean captureOutput) {
        this.captureOutput.set(captureOutput);
    }

    @Override
    public ActionAttributes build() {
        return new ActionAttributes(this.resourceManager.get(), this.nameNode.get(), this.prepare.get(), this.streaming.get(), this.pipes.get(), (ImmutableList<String>)ImmutableList.copyOf(this.jobXmls), ActionAttributesBuilder.convertToConfigurationMap(this.configuration), this.configClass.get(), (ImmutableList<String>)ImmutableList.copyOf(this.files), (ImmutableList<String>)ImmutableList.copyOf(this.archives), (ImmutableList<Delete>)ImmutableList.copyOf(this.deletes), (ImmutableList<Mkdir>)ImmutableList.copyOf(this.mkdirs), (ImmutableList<Move>)ImmutableList.copyOf(this.moves), (ImmutableList<Chmod>)ImmutableList.copyOf(this.chmods), (ImmutableList<Touchz>)ImmutableList.copyOf(this.touchzs), (ImmutableList<Chgrp>)ImmutableList.copyOf(this.chgrps), this.javaOpts.get(), (ImmutableList<String>)ImmutableList.copyOf(this.args), this.launcher.get(), this.captureOutput.get());
    }

    static Map<String, ModifyOnce<String>> convertToModifyOnceMap(Map<String, String> configurationMap) {
        LinkedHashMap<String, ModifyOnce<String>> modifyOnceEntries = new LinkedHashMap<String, ModifyOnce<String>>();
        for (Map.Entry<String, String> keyAndValue : configurationMap.entrySet()) {
            modifyOnceEntries.put(keyAndValue.getKey(), new ModifyOnce<String>(keyAndValue.getValue()));
        }
        return modifyOnceEntries;
    }

    static ImmutableMap<String, String> convertToConfigurationMap(Map<String, ModifyOnce<String>> map) {
        LinkedHashMap<String, String> mutableConfiguration = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ModifyOnce<String>> modifyOnceEntry : map.entrySet()) {
            if (modifyOnceEntry.getValue().get() == null) continue;
            mutableConfiguration.put(modifyOnceEntry.getKey(), modifyOnceEntry.getValue().get());
        }
        return ImmutableMap.copyOf(mutableConfiguration);
    }
}

