/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.adf;

import com.aliyun.dataworks.migrationx.domain.adf.AdfPackage;
import com.aliyun.dataworks.migrationx.domain.adf.LinkedService;
import com.aliyun.dataworks.migrationx.domain.adf.Pipeline;
import com.aliyun.dataworks.migrationx.domain.adf.Trigger;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfPackageLoader {
    private static final Logger log = LoggerFactory.getLogger(AdfPackageLoader.class);
    private static final String PIPELINE_JSON = "pipelines.json";
    private static final String TRIGGER_JSON = "triggers.json";
    private static final String LINKED_SERVICE_JSON = "linked_services.json";
    private final File parentFolder;

    public AdfPackageLoader(File unzippedDir) {
        this.parentFolder = unzippedDir;
    }

    public AdfPackage loadPackage() {
        AdfPackage adfPackage = new AdfPackage();
        adfPackage.setPackageRoot(this.parentFolder);
        adfPackage.setPipelines(this.getPipelines());
        adfPackage.setTriggers(this.getTriggers());
        adfPackage.setLinkedServices(this.getLinkedServices());
        return adfPackage;
    }

    public List<LinkedService> getLinkedServices() {
        try {
            File linkedServices = new File(this.parentFolder, LINKED_SERVICE_JSON);
            String projects = FileUtils.readFileToString((File)linkedServices, (Charset)StandardCharsets.UTF_8);
            return (List)GsonUtils.fromJsonString((String)projects, (Type)new TypeToken<List<LinkedService>>(){}.getType());
        }
        catch (IOException e) {
            log.warn("unable to load linked services", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Map<String, Trigger> getTriggers() {
        try {
            File triggerFile = new File(this.parentFolder, TRIGGER_JSON);
            String projects = FileUtils.readFileToString((File)triggerFile, (Charset)StandardCharsets.UTF_8);
            List triggers = (List)GsonUtils.fromJsonString((String)projects, (Type)new TypeToken<List<Trigger>>(){}.getType());
            if (CollectionUtils.isEmpty((Collection)triggers)) {
                return Collections.emptyMap();
            }
            List validTriggers = triggers.stream().filter(t -> t.getProperties().getRuntimeState().equalsIgnoreCase("Started")).collect(Collectors.toList());
            HashMap<String, Trigger> map = new HashMap<String, Trigger>();
            for (Trigger trigger : validTriggers) {
                List<Trigger.LinkedPipeline> pipelines = trigger.getProperties().getPipelines();
                pipelines.forEach(p -> map.put(p.pipelineReference.referenceName, trigger));
            }
            return map;
        }
        catch (IOException e) {
            log.warn("unable to load triggers", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public List<Pipeline> getPipelines() {
        try {
            File pipelineFile = new File(this.parentFolder, PIPELINE_JSON);
            String projects = FileUtils.readFileToString((File)pipelineFile, (Charset)StandardCharsets.UTF_8);
            return (List)GsonUtils.fromJsonString((String)projects, (Type)new TypeToken<List<Pipeline>>(){}.getType());
        }
        catch (IOException e) {
            log.error("unable to load pipelines", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

