/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dataarts.service;

import com.alibaba.cola.dto.Response;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.migration.spec.domain.DataArtsJob;
import com.aliyun.migration.spec.domain.DataArtsJobDTO;
import com.aliyun.migration.spec.domain.DataArtsJobNodeDTO;
import com.aliyun.migration.spec.domain.DataArtsNode;
import com.aliyun.migration.spec.domain.DataArtsNodeTypeEnum;
import com.aliyun.migration.spec.domain.DataArtsPackage;
import com.aliyun.migration.spec.domain.DataArtsProject;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdm;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJob;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dataarts.util.DataArtsNodeUtils;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DataArtsStudioPackageLoader {
    private static final Logger log = LoggerFactory.getLogger(DataArtsStudioPackageLoader.class);
    private Map<String, File> scriptFileMap = new HashMap<String, File>();

    public Response precheck(String sourceFilePath) {
        return Response.buildSuccess();
    }

    private File getDataFile(File rootDir) {
        File dataDir = null;
        try {
            if (rootDir.isFile()) {
                dataDir = ZipUtils.decompress((File)rootDir);
                if (dataDir.isDirectory()) {
                    File file;
                    File[] files = dataDir.listFiles();
                    dataDir = null != files && files.length == 1 ? (file = files[0]) : new File(dataDir, dataDir.getName());
                }
            } else {
                dataDir = rootDir;
            }
            log.info("load file dataDir:{}", (Object)dataDir.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("load file error ", (Throwable)e);
        }
        return dataDir;
    }

    public DataArtsPackage load(String filePath, BwmConfiguration conf) throws Exception {
        File rootDir = new File(filePath);
        File dataDir = this.getDataFile(rootDir);
        DataArtsPackage dataArtsPackage = new DataArtsPackage();
        if (Objects.isNull(dataDir) || !dataDir.exists()) {
            log.warn("datadir \u3010{}\u3011 is not exists ", (Object)dataDir);
            return null;
        }
        DataArtsProject dataArtsProject = this.exploreProject(dataDir);
        dataArtsPackage.setDataArtsProject(dataArtsProject);
        String jobFileDirectory = dataDir.getAbsolutePath();
        List<File> jobFileList = this.explorationJobList(jobFileDirectory);
        this.explorationScriptsList(jobFileDirectory);
        ArrayList<DataArtsJob> dataArtsJobList = new ArrayList<DataArtsJob>(jobFileList.size());
        for (File jobFile : jobFileList) {
            log.info("begin to deal jobFile name:{}", (Object)jobFile.getPath());
            String jobContent = FileUtils.readFileToString((File)jobFile, (Charset)Charset.forName("UTF-8"));
            DataArtsJobDTO dataArtsJobDTO = (DataArtsJobDTO)JSONObject.parseObject((String)jobContent, DataArtsJobDTO.class);
            DataArtsJob dataArtsJob = new DataArtsJob();
            dataArtsJob.setId(dataArtsJobDTO.getId());
            dataArtsJob.setDataArtsNodeList(this.initDataArtsNodeList(dataArtsJobDTO, dataArtsProject.getDataArtsWorkSpaceId(), jobFileDirectory, jobFile.getPath()));
            dataArtsJob.setName(jobFile.getName().replace(".job", ""));
            dataArtsJob.setDirectory(dataArtsJobDTO.getDirectory());
            if (dataArtsJobDTO.getParams() != null && !dataArtsJobDTO.getParams().isEmpty()) {
                dataArtsJob.setParams(new HashMap());
                dataArtsJobDTO.getParams().forEach(param -> dataArtsJob.getParams().put(param.getName(), param.getValue()));
            }
            dataArtsJob.setScheduleType(dataArtsJobDTO.getSchedule().getType());
            dataArtsJob.setSchedule(dataArtsJobDTO.getSchedule());
            dataArtsJobList.add(dataArtsJob);
        }
        Map<String, List<DataArtsCdmJob>> clusterCdmJobMap = this.explorationCdmJob(dataDir.getPath());
        dataArtsPackage.setDataArtsCdms(clusterCdmJobMap);
        dataArtsPackage.setDataArtsJobList(dataArtsJobList);
        return dataArtsPackage;
    }

    private DataArtsProject getDefaultDataArtsProject() {
        return DataArtsProject.builder().dataArtsWorkSpaceId("dataarts_default").dataArtsWorkspaceName("dataarts_name").build();
    }

    private DataArtsProject exploreProject(File dataDir) {
        DataArtsProject project = new DataArtsProject();
        File projectFile = new File(dataDir, "project.json");
        if (!projectFile.exists()) {
            project.setDataArtsWorkSpaceId("dataarts_default");
            project.setDataArtsWorkspaceName("dataarts_name");
            return project;
        }
        try {
            String projectContent = FileUtils.readFileToString((File)projectFile, (Charset)Charset.forName("UTF-8"));
            return (DataArtsProject)BwmJsonUtil.parseObject((String)projectContent, DataArtsProject.class);
        }
        catch (IOException e) {
            log.error("parse project error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<File> explorationJobList(String jobFileDirectory) {
        String jobDirectory = jobFileDirectory + File.separator + "jobs" + File.separator + "jobs";
        if (!new File(jobDirectory).exists()) {
            log.info("jobDirectory={} is not exist....", (Object)jobDirectory);
            return null;
        }
        List jobFileList = (List)FileUtils.listFiles((File)FileUtils.getFile((String[])new String[]{jobDirectory}), (String[])new String[]{"job"}, (boolean)true);
        log.info("jobFileList size:{}", (Object)jobFileList.size());
        if (CollectionUtils.isEmpty((Collection)jobFileList)) {
            log.info("jobDirectory={} not have job....", (Object)jobDirectory);
            return null;
        }
        return jobFileList;
    }

    public Map<String, List<DataArtsCdmJob>> explorationCdmJob(String filePath) {
        File cmdJobClusterDirecory = new File(filePath + File.separator + "cdms");
        File[] cmdJobParentDirecorys = cmdJobClusterDirecory.listFiles();
        if (null == cmdJobParentDirecorys || cmdJobParentDirecorys.length == 0) {
            log.warn("not found cmds");
            return new HashMap<String, List<DataArtsCdmJob>>();
        }
        HashMap<String, List<DataArtsCdmJob>> clusterCdmJobMap = new HashMap<String, List<DataArtsCdmJob>>();
        for (File cmdJobParentDirecory : cmdJobParentDirecorys) {
            ArrayList cdmJobList = new ArrayList();
            String clusterName = cmdJobParentDirecory.getName();
            List cdmJobJsonList = (List)FileUtils.listFiles((File)cmdJobParentDirecory, (String[])new String[]{"json"}, (boolean)true);
            for (File cdmJobFile : cdmJobJsonList) {
                String cmdJobContent = null;
                try {
                    cmdJobContent = FileUtils.readFileToString((File)cdmJobFile, (Charset)Charset.forName("UTF-8"));
                }
                catch (IOException e) {
                    log.error("readFileToString error ", (Throwable)e);
                }
                if (StringUtils.isEmpty((CharSequence)cmdJobContent)) {
                    log.info("cmdJobFilePath:{} content is empty", (Object)cdmJobFile.getPath());
                    continue;
                }
                DataArtsCdm dataArtsCdm = (DataArtsCdm)JSONObject.parseObject((String)cmdJobContent, DataArtsCdm.class);
                if (dataArtsCdm == null || CollectionUtils.isEmpty((Collection)dataArtsCdm.getJobs())) {
                    log.info("cmdJobFilePath:{} jobs is empty", (Object)cdmJobFile.getPath());
                    continue;
                }
                cdmJobList.addAll(dataArtsCdm.getJobs());
            }
            if (cdmJobList.size() <= 0) continue;
            clusterCdmJobMap.put(clusterName, cdmJobList);
        }
        return clusterCdmJobMap;
    }

    private List<DataArtsNode> initDataArtsNodeList(DataArtsJobDTO dataArtsJobDTO, String dataArtsWorkSpaceId, String jobFileDirectory, String jobPath) {
        List nodes = dataArtsJobDTO.getNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            log.info("dataArts job name:{},nodes size is empty", (Object)dataArtsJobDTO.getName());
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataArtsNode> dataArtsNodeList = new ArrayList<DataArtsNode>(nodes.size());
        for (DataArtsJobNodeDTO dataArtsJobNodeDTO : nodes) {
            DataArtsNode dataArtsNode = (DataArtsNode)BwmJsonUtil.deepCopy((Object)dataArtsJobNodeDTO, DataArtsNode.class);
            if (Objects.isNull(dataArtsNode)) {
                log.warn("deepCopy dataArtsJobNodeDTO {} is null", (Object)dataArtsJobNodeDTO.getName());
                continue;
            }
            dataArtsNode.setDataArtsJobName(dataArtsJobDTO.getName());
            dataArtsNode.setSchedule(dataArtsJobDTO.getSchedule());
            dataArtsNode.setOwner(dataArtsJobDTO.getBasicConfig().getOwner());
            dataArtsNode.setDirectory(dataArtsJobDTO.getDirectory());
            dataArtsNode.setDataArtsWorkSpaceId(dataArtsWorkSpaceId);
            dataArtsNode.setInstanceTimeout(dataArtsJobDTO.getBasicConfig().getInstanceTimeout());
            dataArtsNode.setParams(dataArtsJobDTO.getParams());
            dataArtsNode.setJobPath(jobPath);
            String statementOrScript = DataArtsNodeUtils.getPropertie(dataArtsNode.getProperties(), "statementOrScript");
            if (dataArtsNode.getType().equals(DataArtsNodeTypeEnum.TYPE_Shell.getDataArtsNodeType()) || dataArtsNode.getType().equals(DataArtsNodeTypeEnum.TYPE_HIVE_SQL.getDataArtsNodeType()) || dataArtsNode.getType().equals(DataArtsNodeTypeEnum.TYPE_RDSSQL.getDataArtsNodeType()) || dataArtsNode.getType().equals(DataArtsNodeTypeEnum.TYPE_DWSSQL.getDataArtsNodeType()) || dataArtsNode.getType().equals(DataArtsNodeTypeEnum.TYPE_DLISQL.getDataArtsNodeType()) || dataArtsNode.getType().equals(DataArtsNodeTypeEnum.TYPE_SPRKSQL.getDataArtsNodeType())) {
                if (statementOrScript.equalsIgnoreCase("SCRIPT")) {
                    dataArtsNode.setScriptContent(this.getScript(DataArtsNodeUtils.getPropertie(dataArtsNode.getProperties(), "scriptName")));
                } else if (statementOrScript.equalsIgnoreCase("STATEMENT")) {
                    String statement = DataArtsNodeUtils.getSql(dataArtsNode.getProperties());
                    if (statement == null) {
                        statement = DataArtsNodeUtils.getStatement(dataArtsNode.getProperties());
                    }
                    if (statement != null) {
                        dataArtsNode.setScriptContent(statement);
                    }
                }
            }
            dataArtsNode.setHaveChildren(this.hasChildren(dataArtsJobNodeDTO.getName(), nodes));
            if (dataArtsNode.isHaveChildren()) {
                dataArtsNode.setChildrenNodeTypeList(this.getChildrenNodeTypes(dataArtsJobNodeDTO.getName(), nodes));
            }
            dataArtsNode.setHeadNode(CollectionUtils.isEmpty((Collection)dataArtsJobNodeDTO.getPreNodeName()));
            dataArtsNodeList.add(dataArtsNode);
        }
        return dataArtsNodeList;
    }

    private String getScript(String scriptName) {
        File file = this.scriptFileMap.get(scriptName);
        if (file != null) {
            try {
                JSONObject scriptTextJSON;
                String scriptText = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8"));
                if (StringUtils.isNotEmpty((CharSequence)scriptText) && (scriptTextJSON = JSONObject.parseObject((String)scriptText)).containsKey((Object)"content")) {
                    return scriptTextJSON.getString("content");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean hasChildren(String currentNodeName, List<DataArtsJobNodeDTO> nodes) {
        for (DataArtsJobNodeDTO item : nodes) {
            if (CollectionUtils.isEmpty((Collection)item.getPreNodeName())) continue;
            for (String nodeName : item.getPreNodeName()) {
                if (!nodeName.equals(currentNodeName)) continue;
                return true;
            }
        }
        return false;
    }

    private void explorationScriptsList(String dataDevDir) {
        String scriptDirectory = dataDevDir + File.separator + "jobs" + File.separator + "scripts";
        List scriptFileList = (List)FileUtils.listFiles((File)FileUtils.getFile((String[])new String[]{scriptDirectory}), (String[])new String[]{"script"}, (boolean)true);
        for (File file : scriptFileList) {
            String fileName = file.getName();
            this.scriptFileMap.put(fileName.substring(0, fileName.lastIndexOf(".")), file);
        }
    }

    private List<String> getChildrenNodeTypes(String currentNodeName, List<DataArtsJobNodeDTO> nodes) {
        ArrayList<String> childrenNodeTypeList = new ArrayList<String>();
        block0: for (DataArtsJobNodeDTO item : nodes) {
            if (CollectionUtils.isEmpty((Collection)item.getPreNodeName())) continue;
            for (String nodeName : item.getPreNodeName()) {
                if (!nodeName.equals(currentNodeName)) continue;
                childrenNodeTypeList.add(item.getType());
                continue block0;
            }
        }
        return childrenNodeTypeList;
    }
}

