/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dataarts.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.spec.domain.DataArtsPackage;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.dataarts.convert.DataArts2WorkflowConvert;
import com.aliyun.migration.workflow.migration.dataarts.service.DataArtsStudioPackageLoader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DataArtsStudioReader
extends AbstractReader {
    private DataArtsStudioPackageLoader loader;
    private DataArts2WorkflowConvert convert;

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(scheduleDataSource);
        this.loader = new DataArtsStudioPackageLoader();
        this.convert = new DataArts2WorkflowConvert();
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        Map properties = scheduleDataSource.getProperties();
        String sourFilePath = (String)properties.get("source-file-path");
        if (StringUtils.isBlank((CharSequence)sourFilePath)) {
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"sourceFilePath is null");
        }
        return this.loader.precheck(sourFilePath);
    }

    public WorkflowProjectPackage read() throws Exception {
        String bwmConfiguration = this.taskContext.getBwmConfiguration();
        BwmConfiguration conf = null;
        if (StringUtils.isNotEmpty((CharSequence)bwmConfiguration)) {
            conf = BwmConfiguration.from((String)bwmConfiguration);
        }
        DataArtsPackage load = this.loader.load(this.taskContext.getSourceFilePackage(), conf);
        WorkflowProjectPackage workflowProjectPackage = this.convert.convert(load);
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }
}

