/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.dw.newidea.reader.handle;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks_public20240518.models.GetProjectResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.WorkflowMainSpec;
import com.aliyun.migration.spec.domain.dataworks.node.EndPoint;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.dw.newidea.reader.handle.AbstractDwIdeaHandler;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.DwNewideClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewIdeaOpenApiHandler
extends AbstractDwIdeaHandler {
    private static final Logger log = LoggerFactory.getLogger(DwNewIdeaOpenApiHandler.class);
    private DwNewideClient client;
    private String projectIdStr;

    public DwNewIdeaOpenApiHandler(Datasource datasource, TaskContext taskContext) {
        super(datasource, taskContext);
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        Map properties = scheduleDataSource.getProperties();
        this.projectIdStr = (String)properties.get("project");
        if (!NumberUtils.isDigits((String)this.projectIdStr)) {
            log.error("Project id is not number or not found");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PROJECT_CONF_NOT_FOUND);
        }
        String env_ak = System.getenv("LHM_DW_AK");
        String env_sk = System.getenv("LHM_DW_SK");
        if (StringUtils.isNotBlank((CharSequence)env_ak) && StringUtils.isNotBlank((CharSequence)env_sk)) {
            properties.put("ak", env_ak);
            properties.put("sk", env_sk);
        }
        this.client = new DwNewideClient((String)properties.get("ak"), (String)properties.get("sk"), (String)properties.get("endpoint"), EndPoint.getEndPoint((String)((String)properties.get("endpoint"))).getName());
    }

    @Override
    public WorkflowProjectPackage read() {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        GetProjectResponseBody.GetProjectResponseBodyProject projectInfo = this.client.getProject(this.projectIdStr);
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(projectInfo.getId().toString());
        workflowProject.setName(projectInfo.getName());
        workflowProject.setDescription(projectInfo.getDescription());
        workflowProjectPackage.setWorkflowProject(workflowProject);
        List wfMainSpecList = this.client.listWorkflowMainSpec(this.projectIdStr, Boolean.valueOf(true));
        List workflowList = WorkflowMainSpec.getWorkflowList((List)wfMainSpecList);
        workflowProjectPackage.setWorkflowList(workflowList);
        for (Workflow workflow : workflowList) {
            workflow.setProjectId(workflowProject.getProjectId());
            workflow.setProjectName(workflowProject.getName());
            for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                workflowNode.setProjectId(workflowProject.getProjectId());
                workflowNode.setProjectName(workflowProject.getName());
            }
        }
        BwmConfiguration Configuration = BwmConfiguration.from((String)this.taskContext.getBwmConfiguration());
        if (Configuration.getBool("getDeployRecord") != null && Configuration.getBool("getDeployRecord").booleanValue()) {
            Map state = this.client.listPipelineState(this.projectIdStr);
            for (Workflow workflow : workflowList) {
                DwNewideClient.PipelineState pipelineState = (DwNewideClient.PipelineState)state.get(Long.parseLong(workflow.getWorkflowId()));
                if (pipelineState != null) {
                    if (workflow.getCustomProperties() == null) {
                        workflow.setCustomProperties(new HashMap());
                    }
                    workflow.getCustomProperties().put("online.pipeline.state", JSONObject.toJSONString((Object)pipelineState, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
                    continue;
                }
                workflow.getCustomProperties().put("online.pipeline.state", "\u672a\u53d1\u5e03");
            }
        } else {
            for (Workflow workflow : workflowList) {
                workflow.getCustomProperties().put("online.pipeline.state", "\u672a\u83b7\u53d6\u53d1\u5e03\u8bb0\u5f55");
            }
        }
        return workflowProjectPackage;
    }

    public void analyze(WorkflowProjectPackage pkg) {
    }
}

