/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowTriggerSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowTriggerSheetProperties.class);
    private Map<WorkflowTriggerSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowTriggerSheetColumn, Integer>();
    private Map<WorkflowTriggerSheetColumn, Object> propertyValueMap = new HashMap<WorkflowTriggerSheetColumn, Object>();

    public WorkflowTriggerSheetProperties() {
        for (WorkflowTriggerSheetColumn column : WorkflowTriggerSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowTriggerSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowTriggerSheetColumn column = WorkflowTriggerSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowTriggerSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowTriggerSheetColumn column = WorkflowTriggerSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return List.of();
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return List.of();
    }

    @Override
    public List<String> getValuesForExcel() {
        return List.of();
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public void setPropertyValue(Map<WorkflowTriggerSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowTriggerSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(Workflow workflow, WorkflowTrigger trigger) {
        this.setPropertyValue(WorkflowTriggerSheetColumn.PROJECT_ID, workflow.getProjectId());
        this.setPropertyValue(WorkflowTriggerSheetColumn.WORKFLOW_ID, workflow.getWorkflowId());
        this.setPropertyValue(WorkflowTriggerSheetColumn.NAME, trigger.getName());
        this.setPropertyValue(WorkflowTriggerSheetColumn.TYPE, trigger.getType());
        this.setPropertyValue(WorkflowTriggerSheetColumn.CRON, trigger.getCron());
        this.setPropertyValue(WorkflowTriggerSheetColumn.START_TIME, trigger.getStartTime());
        this.setPropertyValue(WorkflowTriggerSheetColumn.END_TIME, trigger.getEndTime());
        this.setPropertyValue(WorkflowTriggerSheetColumn.TIMEZONE, trigger.getTimezone());
        this.setPropertyValue(WorkflowTriggerSheetColumn.DESCRIPTION, trigger.getDescription());
    }

    public void setPropertyValue(WorkflowNode node, WorkflowTrigger trigger) {
        this.setPropertyValue(WorkflowTriggerSheetColumn.PROJECT_ID, node.getProjectId());
        this.setPropertyValue(WorkflowTriggerSheetColumn.WORKFLOW_ID, node.getWorkflowId());
        this.setPropertyValue(WorkflowTriggerSheetColumn.NODE_ID, node.getNodeId());
        this.setPropertyValue(WorkflowTriggerSheetColumn.NAME, trigger.getName());
        this.setPropertyValue(WorkflowTriggerSheetColumn.TYPE, trigger.getType());
        this.setPropertyValue(WorkflowTriggerSheetColumn.CRON, trigger.getCron());
        this.setPropertyValue(WorkflowTriggerSheetColumn.START_TIME, trigger.getStartTime());
        this.setPropertyValue(WorkflowTriggerSheetColumn.END_TIME, trigger.getEndTime());
        this.setPropertyValue(WorkflowTriggerSheetColumn.TIMEZONE, trigger.getTimezone());
        this.setPropertyValue(WorkflowTriggerSheetColumn.DESCRIPTION, trigger.getDescription());
    }

    public static enum WorkflowTriggerSheetColumn {
        PROJECT_ID("\u9879\u76ee\u7a7a\u95f4ID", false, false, true),
        WORKFLOW_ID("\u5de5\u4f5c\u6d41ID", false, false, true),
        NODE_ID("\u8282\u70b9ID", false, false, true),
        NAME("Trigger\u540d\u79f0", false, false, true),
        TYPE("Trigger\u7c7b\u578b", false, false, true),
        CRON("Cron\u8868\u8fbe\u5f0f", false, false, true),
        START_TIME("\u5f00\u59cb\u65f6\u95f4", false, false, true),
        END_TIME("\u7ed3\u675f\u65f6\u95f4", false, false, true),
        TIMEZONE("\u65f6\u533a", false, false, true),
        DESCRIPTION("\u5907\u6ce8", false, false, true),
        EXTRA("\u6269\u5c55\u4fe1\u606f", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowTriggerSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowTriggerSheetColumn of(String colName) {
            for (WorkflowTriggerSheetColumn column : WorkflowTriggerSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

