/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowNodeSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowNodeSheetProperties.class);
    private Map<WorkflowNodeSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowNodeSheetColumn, Integer>();
    private Map<WorkflowNodeSheetColumn, Object> propertyValueMap = new HashMap<WorkflowNodeSheetColumn, Object>();

    public WorkflowNodeSheetProperties() {
        for (WorkflowNodeSheetColumn column : WorkflowNodeSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowNodeSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowNodeSheetColumn column = WorkflowNodeSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowNodeSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowNodeSheetColumn column = WorkflowNodeSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowNodeSheetColumn::getIsForExcel).map(WorkflowNodeSheetColumn::getDescription).collect(Collectors.toList());
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowNodeSheetColumn::getIsForExcel).map(WorkflowNodeSheetColumn::getCanModify).collect(Collectors.toList());
    }

    @Override
    public List<String> getValuesForExcel() {
        ArrayList<String> values = new ArrayList<String>();
        this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowNodeSheetColumn::getIsForExcel).forEach(property -> {
            if (ObjectUtils.isEmpty((Object)this.propertyValueMap.get(property))) {
                values.add("");
            } else {
                values.add(String.valueOf(this.propertyValueMap.get(property)));
            }
        });
        return values;
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                if (v instanceof String && ((String)v).length() > 65533) {
                    v = "\u3010\u8b66\u544a\u3011\u5185\u5bb9\u8d85\u957f\uff0c\u9875\u9762\u622a\u65ad\u663e\u793a\uff0c\u4e0d\u5f71\u54cd\u8fc1\u79fb\uff01\n" + ((String)v).substring(0, 60000);
                }
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public Integer getPropertyIndex(WorkflowNodeSheetColumn column) {
        if (this.propertyIndexMap.containsKey((Object)column)) {
            return this.propertyIndexMap.get((Object)column);
        }
        return null;
    }

    public Object getPropertyValue(WorkflowNodeSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column)) {
            return this.propertyValueMap.get((Object)column);
        }
        return null;
    }

    public Boolean isPropertyValueValidNotNull(WorkflowNodeSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.isEmpty((Object)this.propertyValueMap.get((Object)column)) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public Boolean isPropertyValueValid(WorkflowNodeSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public void setPropertyValue(Map<WorkflowNodeSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowNodeSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(WorkflowNode node) {
        this.setPropertyValue((Workflow)null, node);
    }

    public void setPropertyValue(Workflow workflow, WorkflowNode node) {
        String params = "{}";
        if (node.getParamMap() != null) {
            params = JSONObject.toJSONString((Object)node.getParamMap(), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        String advancedParams = "{}";
        if (node.getCustomProperties() != null) {
            advancedParams = JSONObject.toJSONString((Object)node.getCustomProperties(), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        String paramsInScript = "{}";
        if (node.getCustomProperties() == null) {
            node.setCustomProperties(new HashMap());
        }
        if (node.getCustomProperties().containsKey(StatisticsReportConstant.RAW_SCRIPT_PARAMS)) {
            List rawScriptParams = (List)node.getCustomProperties().get(StatisticsReportConstant.RAW_SCRIPT_PARAMS);
            JSONObject paramsInScriptJson = new JSONObject();
            for (String rawScriptParam : rawScriptParams) {
                paramsInScriptJson.put((Object)rawScriptParam, (Object)rawScriptParam);
            }
            paramsInScript = paramsInScriptJson.toJSONString(new JSONWriter.Feature[0]);
        }
        this.setPropertyValue(WorkflowNodeSheetColumn.NODE_ID, node.getNodeId());
        this.setPropertyValue(WorkflowNodeSheetColumn.NODE_NAME, node.getNodeName());
        this.setPropertyValue(WorkflowNodeSheetColumn.TGT_NODE_ID, node.getTNodeId());
        this.setPropertyValue(WorkflowNodeSheetColumn.TGT_NODE_NAME, null);
        this.setPropertyValue(WorkflowNodeSheetColumn.OWNER, node.getOwner());
        this.setPropertyValue(WorkflowNodeSheetColumn.OWNER_TYPE, node.getOwnerType());
        this.setPropertyValue(WorkflowNodeSheetColumn.CATEGORY_VALUE, node.getCategoryValue());
        this.setPropertyValue(WorkflowNodeSheetColumn.DESCRIPTION, node.getDescription());
        if (workflow != null) {
            this.setPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_ID, workflow.getWorkflowId());
            this.setPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_NAME, workflow.getWorkflowName());
            this.setPropertyValue(WorkflowNodeSheetColumn.PROJECT_ID, workflow.getProjectId());
        } else {
            this.setPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_ID, node.getWorkflowId());
            this.setPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_NAME, node.getWorkflowName());
            this.setPropertyValue(WorkflowNodeSheetColumn.PROJECT_ID, node.getProjectId());
        }
        this.setPropertyValue(WorkflowNodeSheetColumn.NODE_TYPE, node.getNodeType());
        this.setPropertyValue(WorkflowNodeSheetColumn.DB_TYPE, node.getDbType());
        this.setPropertyValue(WorkflowNodeSheetColumn.ENGINE_NAME, node.getCustomProperties() != null && node.getCustomProperties().containsKey("datasource") && !StringUtils.isEmpty((CharSequence)((String)node.getCustomProperties().get("datasource"))) ? node.getCustomProperties().get("datasource") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.PARAM, params);
        this.setPropertyValue(WorkflowNodeSheetColumn.SCRIPT, node.getScript());
        this.setPropertyValue(WorkflowNodeSheetColumn.SCRIPT_PATH, node.getScriptPath());
        this.setPropertyValue(WorkflowNodeSheetColumn.SCRIPT_PARAMS, paramsInScript);
        this.setPropertyValue(WorkflowNodeSheetColumn.CRON, node.getTrigger() != null && !StringUtils.isEmpty((CharSequence)node.getTrigger().getCron()) ? node.getTrigger().getCron() : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.INSTANCE_MODE, node.getInstanceMode() != null ? node.getInstanceMode().name() : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.SCHEDULE_MODE, node.getState() != null ? node.getState().name() : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.RERUN_MODE, node.getRerunMode() != null ? node.getRerunMode().name() : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.TIMEOUT, node.getTimeout());
        this.setPropertyValue(WorkflowNodeSheetColumn.PRIORITY, node.getPriority());
        this.setPropertyValue(WorkflowNodeSheetColumn.RUNTIME_RESOURCE, node.getRuntimeResource() != null ? JSONObject.toJSONString((Object)node.getRuntimeResource(), (JSONWriter.Feature[])new JSONWriter.Feature[0]) : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.RESOURCE_GROUP_IDENTIFIER, node.getRuntimeResource() != null && node.getRuntimeResource().containsKey("resource.group.identifier") && !ObjectUtils.isEmpty(node.getRuntimeResource().get("resource.group.identifier")) ? node.getRuntimeResource().get("resource.group.identifier") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.WORFKLOW_SCHDULE_CU, node.getRuntimeResource() != null && node.getRuntimeResource().containsKey("workflow.schedule.cu") && !ObjectUtils.isEmpty(node.getRuntimeResource().get("workflow.schedule.cu")) ? node.getRuntimeResource().get("workflow.schedule.cu") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.RESOURCE_GROUP_IMAGE_ID, node.getRuntimeResource() != null && node.getRuntimeResource().containsKey("resource.group.image.id") && !ObjectUtils.isEmpty(node.getRuntimeResource().get("resource.group.image.id")) ? node.getRuntimeResource().get("resource.group.image.id") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.DI_RESOURCE_GROUP_IDENTIFIER, node.getRuntimeResource() != null && node.getRuntimeResource().containsKey("di.resource.group.identifier") && !ObjectUtils.isEmpty(node.getRuntimeResource().get("di.resource.group.identifier")) ? node.getRuntimeResource().get("di.resource.group.identifier") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_DI_CU, node.getRuntimeResource() != null && node.getRuntimeResource().containsKey("workflow.di.cu") && !ObjectUtils.isEmpty(node.getRuntimeResource().get("workflow.di.cu")) ? node.getRuntimeResource().get("workflow.di.cu") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.OFFLINE_STATE, node.getCustomProperties() != null && node.getCustomProperties().containsKey("online.pipeline.state") && !ObjectUtils.isEmpty(node.getCustomProperties().get("online.pipeline.state")) ? node.getCustomProperties().get("online.pipeline.state") : null);
        this.setPropertyValue(WorkflowNodeSheetColumn.ORIGINAL_ID, node.getCustomProperties() != null && node.getCustomProperties().containsKey("MigrationOriginalId") && !ObjectUtils.isEmpty(node.getCustomProperties().get("MigrationOriginalId")) ? node.getCustomProperties().get("MigrationOriginalId") : null);
    }

    public void setPropertyValue(List<String> propertyValueList) {
        for (WorkflowNodeSheetColumn column : this.propertyIndexMap.keySet()) {
            Integer sheetIndex = this.propertyIndexMap.get((Object)column);
            if (sheetIndex >= propertyValueList.size()) {
                this.propertyValueMap.put(column, null);
                continue;
            }
            this.propertyValueMap.put(column, propertyValueList.get(sheetIndex));
        }
    }

    public void setNodePropertyValueForExcel(WorkflowNode workflowNode) {
        if (this.isPropertyValueValid(WorkflowNodeSheetColumn.OWNER).booleanValue()) {
            workflowNode.setOwner((String)this.getPropertyValue(WorkflowNodeSheetColumn.OWNER));
        }
        if (this.isPropertyValueValid(WorkflowNodeSheetColumn.DESCRIPTION).booleanValue()) {
            workflowNode.setDescription((String)this.getPropertyValue(WorkflowNodeSheetColumn.DESCRIPTION));
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.ENGINE_NAME).booleanValue()) {
            if (workflowNode.getCustomProperties() == null) {
                workflowNode.setCustomProperties(new HashMap());
            }
            workflowNode.getCustomProperties().put("datasource", this.getPropertyValue(WorkflowNodeSheetColumn.ENGINE_NAME));
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.ENGINE_NAME).booleanValue() && workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("datasource")) {
            workflowNode.getCustomProperties().remove("datasource");
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.PARAM).booleanValue()) {
            try {
                JSONObject paramJsonObj = JSONObject.parseObject((String)((String)this.getPropertyValue(WorkflowNodeSheetColumn.PARAM)));
                workflowNode.setParamMap(new HashMap());
                for (Object k : paramJsonObj.keySet()) {
                    workflowNode.getParamMap().put(k, paramJsonObj.get((String)k));
                }
            }
            catch (Exception e) {
                log.warn("\u8282\u70b9{}\u6b32\u66f4\u65b0Param\uff0c\u4f46\u83b7\u53d6\u5230\u975e\u6cd5\u503c:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), this.getPropertyValue(WorkflowNodeSheetColumn.PARAM));
                workflowNode.setParamMap(null);
            }
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.PARAM).booleanValue()) {
            workflowNode.setParamMap(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.SCRIPT_PARAMS).booleanValue()) {
            try {
                JSONObject paramInScript = JSONObject.parseObject((String)((String)this.getPropertyValue(WorkflowNodeSheetColumn.SCRIPT_PARAMS)));
                String script = workflowNode.getScript();
                if (!paramInScript.isEmpty() && !StringUtils.isEmpty((CharSequence)script)) {
                    for (String k : paramInScript.keySet()) {
                        if (StringUtils.equals((CharSequence)k, (CharSequence)paramInScript.get(k).toString())) continue;
                        script = script.replace(k, paramInScript.get(k).toString());
                    }
                }
                workflowNode.setScript(script);
            }
            catch (Exception e) {
                log.warn("\u8282\u70b9{}\u6b32\u66f4\u65b0ParamInScript\uff0c\u4f46\u83b7\u53d6\u5230\u975e\u6cd5\u503c:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), this.getPropertyValue(WorkflowNodeSheetColumn.SCRIPT_PARAMS));
            }
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.CRON).booleanValue()) {
            if (workflowNode.getTrigger() == null) {
                workflowNode.setTrigger(new WorkflowTrigger());
            }
            workflowNode.getTrigger().setCron((String)this.getPropertyValue(WorkflowNodeSheetColumn.CRON));
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.CRON).booleanValue() && workflowNode.getTrigger() != null) {
            workflowNode.getTrigger().setCron(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.INSTANCE_MODE).booleanValue()) {
            try {
                workflowNode.setInstanceMode(WorkflowNode.InstanceMode.valueOf((String)((String)this.getPropertyValue(WorkflowNodeSheetColumn.INSTANCE_MODE))));
            }
            catch (Exception e) {
                log.warn("\u8282\u70b9{}\u6b32\u66f4\u65b0InstanceMode\uff0c\u4f46\u83b7\u53d6\u5230\u975e\u6cd5\u503c:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), this.getPropertyValue(WorkflowNodeSheetColumn.INSTANCE_MODE));
                workflowNode.setInstanceMode(null);
            }
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.INSTANCE_MODE).booleanValue()) {
            workflowNode.setInstanceMode(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.SCHEDULE_MODE).booleanValue()) {
            try {
                workflowNode.setState(WorkflowNode.Recurrence.valueOf((String)((String)this.getPropertyValue(WorkflowNodeSheetColumn.SCHEDULE_MODE))));
            }
            catch (Exception e) {
                log.warn("\u8282\u70b9{}\u6b32\u66f4\u65b0State\uff0c\u4f46\u83b7\u53d6\u5230\u975e\u6cd5\u503c:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), this.getPropertyValue(WorkflowNodeSheetColumn.SCHEDULE_MODE));
                workflowNode.setState(null);
            }
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.SCHEDULE_MODE).booleanValue()) {
            workflowNode.setState(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.RERUN_MODE).booleanValue()) {
            try {
                workflowNode.setRerunMode(WorkflowNode.RerunMode.valueOf((String)((String)this.getPropertyValue(WorkflowNodeSheetColumn.RERUN_MODE))));
            }
            catch (Exception e) {
                log.warn("\u8282\u70b9{}\u6b32\u66f4\u65b0RerunMode\uff0c\u4f46\u83b7\u53d6\u5230\u975e\u6cd5\u503c:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), this.getPropertyValue(WorkflowNodeSheetColumn.RERUN_MODE));
                workflowNode.setRerunMode(null);
            }
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.RERUN_MODE).booleanValue()) {
            workflowNode.setRerunMode(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.RESOURCE_GROUP_IDENTIFIER).booleanValue()) {
            if (workflowNode.getRuntimeResource() == null) {
                workflowNode.setRuntimeResource(new HashMap());
            }
            workflowNode.getRuntimeResource().put("resource.group.identifier", (String)this.getPropertyValue(WorkflowNodeSheetColumn.RESOURCE_GROUP_IDENTIFIER));
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.RESOURCE_GROUP_IDENTIFIER).booleanValue() && workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("resource.group.identifier")) {
            workflowNode.getRuntimeResource().remove("resource.group.identifier");
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.WORFKLOW_SCHDULE_CU).booleanValue()) {
            if (workflowNode.getRuntimeResource() == null) {
                workflowNode.setRuntimeResource(new HashMap());
            }
            workflowNode.getRuntimeResource().put("workflow.schedule.cu", (String)this.getPropertyValue(WorkflowNodeSheetColumn.WORFKLOW_SCHDULE_CU));
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.WORFKLOW_SCHDULE_CU).booleanValue() && workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("workflow.schedule.cu")) {
            workflowNode.getRuntimeResource().remove("workflow.schedule.cu");
        }
        if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.RESOURCE_GROUP_IMAGE_ID).booleanValue()) {
            if (workflowNode.getRuntimeResource() == null) {
                workflowNode.setRuntimeResource(new HashMap());
            }
            workflowNode.getRuntimeResource().put("resource.group.image.id", (String)this.getPropertyValue(WorkflowNodeSheetColumn.RESOURCE_GROUP_IMAGE_ID));
        } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.RESOURCE_GROUP_IMAGE_ID).booleanValue() && workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("resource.group.image.id")) {
            workflowNode.getRuntimeResource().remove("resource.group.image.id");
        }
        if (workflowNode.getNodeType().equalsIgnoreCase(CodeProgramType.DI.name())) {
            JSONObject script;
            if (workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("datasource")) {
                String datasources = (String)workflowNode.getCustomProperties().get("datasource");
                List<String> srcDs = Arrays.asList(datasources.substring(0, datasources.indexOf(",")).trim().split(" "));
                String destDs = datasources.substring(datasources.indexOf(",") + 1).trim();
                try {
                    JSONObject script2 = JSONObject.parseObject((String)workflowNode.getScript());
                    script2.getJSONArray("steps").forEach(x -> {
                        JSONObject step = (JSONObject)x;
                        if (step.containsKey("category") && step.getString("category").equalsIgnoreCase("reader")) {
                            if (!step.containsKey("parameter")) {
                                step.put((Object)"parameter", (Object)new JSONObject());
                            }
                            if (step.getJSONObject("parameter").containsKey("datasource") && !srcDs.isEmpty()) {
                                step.getJSONObject("parameter").put((Object)"datasource", srcDs.get(0));
                            } else if (step.getJSONObject("parameter").containsKey("connection")) {
                                JSONArray connections = step.getJSONObject("parameter").getJSONArray("connection");
                                for (int i = 0; i < connections.size(); ++i) {
                                    JSONObject connection = connections.getJSONObject(i);
                                    if (srcDs.isEmpty() || srcDs.size() <= i) continue;
                                    connection.put((Object)"datasource", srcDs.get(i));
                                }
                            } else {
                                step.getJSONObject("parameter").put((Object)"datasource", srcDs.get(0));
                            }
                        } else if (step.containsKey("category") && step.getString("category").equalsIgnoreCase("writer")) {
                            if (!step.containsKey("parameter")) {
                                step.put((Object)"parameter", (Object)new JSONObject());
                            }
                            if (step.getJSONObject("parameter").containsKey("datasource")) {
                                step.getJSONObject("parameter").put((Object)"datasource", (Object)destDs);
                            }
                        }
                    });
                    workflowNode.setScript(script2.toJSONString(new JSONWriter.Feature[0]));
                }
                catch (Exception e) {
                    log.error("\u8282\u70b9{}\u6b32\u66f4\u65b0DI\u5185\u5bb9\uff0c\u4f46\u811a\u672c\u5185\u5bb9\u975e\u6cd5:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), (Object)e);
                }
            }
            if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.DI_RESOURCE_GROUP_IDENTIFIER).booleanValue()) {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("di.resource.group.identifier", (String)this.getPropertyValue(WorkflowNodeSheetColumn.DI_RESOURCE_GROUP_IDENTIFIER));
                try {
                    script = JSONObject.parseObject((String)workflowNode.getScript());
                    if (!script.containsKey("extend")) {
                        script.put((Object)"extend", (Object)new JSONObject());
                    }
                    script.getJSONObject("extend").put((Object)"resourceGroup", this.getPropertyValue(WorkflowNodeSheetColumn.DI_RESOURCE_GROUP_IDENTIFIER));
                    workflowNode.setScript(script.toJSONString(new JSONWriter.Feature[0]));
                }
                catch (Exception e) {
                    log.error("\u8282\u70b9{}\u6b32\u66f4\u65b0DI\u5185\u5bb9\uff0c\u4f46\u811a\u672c\u5185\u5bb9\u975e\u6cd5:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), (Object)e);
                }
            } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.DI_RESOURCE_GROUP_IDENTIFIER).booleanValue() && workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("di.resource.group.identifier")) {
                workflowNode.getRuntimeResource().remove("di.resource.group.identifier");
                try {
                    script = JSONObject.parseObject((String)workflowNode.getScript());
                    if (script.containsKey("extend") && script.getJSONObject("extend").containsKey("resourceGroup")) {
                        script.getJSONObject("extend").remove((Object)"resourceGroup");
                    }
                    workflowNode.setScript(script.toJSONString(new JSONWriter.Feature[0]));
                }
                catch (Exception e) {
                    log.error("\u8282\u70b9{}\u6b32\u66f4\u65b0DI\u5185\u5bb9\uff0c\u4f46\u811a\u672c\u5185\u5bb9\u975e\u6cd5:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), (Object)e);
                }
            }
            if (this.isPropertyValueValidNotNull(WorkflowNodeSheetColumn.WORKFLOW_DI_CU).booleanValue()) {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("workflow.di.cu", (String)this.getPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_DI_CU));
                try {
                    script = JSONObject.parseObject((String)workflowNode.getScript());
                    if (!script.containsKey("extend")) {
                        script.put((Object)"extend", (Object)new JSONObject());
                    }
                    script.getJSONObject("extend").put((Object)"cu", (Object)Float.valueOf((String)this.getPropertyValue(WorkflowNodeSheetColumn.WORKFLOW_DI_CU)));
                    workflowNode.setScript(script.toJSONString(new JSONWriter.Feature[0]));
                }
                catch (Exception e) {
                    log.error("\u8282\u70b9{}\u6b32\u66f4\u65b0DI\u5185\u5bb9\uff0c\u4f46\u811a\u672c\u5185\u5bb9\u975e\u6cd5:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), (Object)e);
                }
            } else if (this.isPropertyValueValid(WorkflowNodeSheetColumn.WORKFLOW_DI_CU).booleanValue() && workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("workflow.di.cu")) {
                workflowNode.getRuntimeResource().remove("workflow.di.cu");
                try {
                    script = JSONObject.parseObject((String)workflowNode.getScript());
                    if (script.containsKey("extend") && script.getJSONObject("extend").containsKey("cu")) {
                        script.getJSONObject("extend").remove((Object)"cu");
                    }
                    workflowNode.setScript(script.toJSONString(new JSONWriter.Feature[0]));
                }
                catch (Exception e) {
                    log.error("\u8282\u70b9{}\u6b32\u66f4\u65b0DI\u5185\u5bb9\uff0c\u4f46\u811a\u672c\u5185\u5bb9\u975e\u6cd5:{}", (Object)(workflowNode.getNodeId() + workflowNode.getNodeName()), (Object)e);
                }
            }
        }
    }

    public static enum WorkflowNodeSheetColumn {
        NODE_ID("ID", false, true, true),
        NODE_NAME("\u540d\u79f0", false, true, false),
        TGT_NODE_ID("\u76ee\u6807ID\uff08Writer\u5199\u5165\u540e\uff09", false, true, false),
        TGT_NODE_NAME("\u76ee\u6807\u540d\u79f0\uff08Writer\u5199\u5165\u540e\uff09", false, true, false),
        OWNER("\u8d23\u4efb\u4eba", true, true, false),
        OWNER_TYPE("\u8d23\u4efb\u4eba\u7c7b\u578b", false, false, true),
        DESCRIPTION("\u5907\u6ce8", true, true, false),
        PROJECT_ID("\u6240\u5c5e\u5de5\u4f5c\u7a7a\u95f4ID", false, false, true),
        WORKFLOW_ID("\u6240\u5c5eWorkflowID", false, true, true),
        CATEGORY_VALUE("\u8282\u70b9\u76ee\u5f55\u503c", false, false, true),
        WORKFLOW_NAME("\u6240\u5c5eWorkflowName", false, true, false),
        NODE_TYPE("\u7c7b\u578b", false, true, true),
        DB_TYPE("\u76f8\u5173\u6570\u636e\u6e90\u7c7b\u578b", false, true, true),
        ENGINE_NAME("\u76f8\u5173\u6570\u636e\u6e90", true, true, true),
        PARAM("\u8c03\u5ea6\u53c2\u6570\uff08JSON\u683c\u5f0f\uff09", true, true, false),
        ADVANCED_PARAM("\u8fdb\u9636\u53c2\u6570", false, false, true),
        SCRIPT("\u811a\u672c", false, false, true),
        SCRIPT_PATH("\u811a\u672c\u5728\u5305\u5185\u76f8\u5bf9\u4f4d\u7f6e", false, false, true),
        SCRIPT_PARAMS("\u811a\u672c\u53c2\u6570\u63d0\u53d6\uff08JSON\u683c\u5f0f\uff09", true, true, false),
        CRON("\u8c03\u5ea6\u4fe1\u606f\uff08Cron\u8868\u8fbe\u5f0f\uff09", true, true, false),
        INSTANCE_MODE("\u5b9e\u4f8b\u751f\u6210\u65b9\u5f0f\uff08IMMEDIATELY/T_PLUS_1\uff09", true, true, false),
        SCHEDULE_MODE("\u8c03\u5ea6\u7c7b\u578b\uff08NORMAL/PAUSE/SKIP\uff09", true, true, true),
        RERUN_MODE("\u91cd\u8dd1\u7c7b\u578b\uff08ALL_ALLOWED/ALL_DENIED/FAILURE_ALLOWED\uff09", true, true, false),
        TIMEOUT("\u8d85\u65f6\u65f6\u95f4", false, false, true),
        PRIORITY("\u4f18\u5148\u7ea7", false, false, true),
        RUNTIME_RESOURCE("\u8fd0\u884c\u65f6\u8d44\u6e90", false, false, true),
        RESOURCE_GROUP_IDENTIFIER("\u8c03\u5ea6\u8d44\u6e90\u7ec4", true, true, false),
        WORFKLOW_SCHDULE_CU("\u8ba1\u7b97CU", true, true, false),
        RESOURCE_GROUP_IMAGE_ID("\u955c\u50cf", true, true, false),
        DI_RESOURCE_GROUP_IDENTIFIER("\u6570\u636e\u96c6\u6210\u8d44\u6e90\u7ec4\uff08\u4ec5DI\uff09", true, true, false),
        WORKFLOW_DI_CU("\u6570\u636e\u96c6\u6210cu\uff08\u4ec5DI\uff09", true, true, false),
        OFFLINE_STATE("\u53d1\u5e03\u72b6\u6001", false, false, true),
        ORIGINAL_ID("\u6e90\u7aefID\uff08\u82e5\u4efb\u52a1\u6d41\u7531\u8fc1\u79fb\u800c\u6765\uff09", false, true, false),
        EXTRA("\u6269\u5c55\u4fe1\u606f", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowNodeSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowNodeSheetColumn of(String colName) {
            for (WorkflowNodeSheetColumn column : WorkflowNodeSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

