/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.utils.UuidUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public abstract class AbstractSheetProperties {
    private String tenant_id;
    private String gmt_create;
    private String gmt_modified;
    private Integer is_deleted;
    private String meta_version;
    private Long schedule_datasource_id;

    public abstract List<String> getHeadersForExcel();

    public abstract List<Boolean> getColumnsCanModifyForExcel();

    public abstract List<String> getValuesForExcel();

    protected abstract JSONObject getValuesToJSON();

    public void setMetaInfo(String tenant_id, String meta_version, Long schedule_datasource_id) {
        this.tenant_id = tenant_id;
        this.gmt_create = AbstractSheetProperties.getCurrentTime();
        this.gmt_modified = AbstractSheetProperties.getCurrentTime();
        this.is_deleted = 0;
        this.meta_version = meta_version;
        this.schedule_datasource_id = schedule_datasource_id;
    }

    public JSONObject getValuesForSR() {
        JSONObject jsonObject = this.getValuesToJSON();
        jsonObject.put((Object)"tenant_id", (Object)this.tenant_id);
        jsonObject.put((Object)"gmt_create", (Object)this.gmt_create);
        jsonObject.put((Object)"gmt_modified", (Object)this.gmt_modified);
        jsonObject.put((Object)"is_deleted", (Object)this.is_deleted);
        jsonObject.put((Object)"meta_version", (Object)this.meta_version);
        jsonObject.put((Object)"schedule_datasource_id", (Object)this.schedule_datasource_id);
        jsonObject.put((Object)"uuid", (Object)UuidUtils.randomUuidByObject(jsonObject));
        return jsonObject;
    }

    public static String getCurrentTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.now().format(formatter);
    }
}

