/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util.matcher;

import com.aliyun.securitysdk.rass.resolver.formatter.mask.DomainMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.FilePathMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.MatcherMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.SubnetMask;
import java.util.HashMap;
import java.util.Map;

public enum StringMatcherEnum {
    INTRANET_IP("intranet ip", SubnetMask.class),
    INTRANET_IPV6("intranet ipv6", SubnetMask.class),
    ALLOWED_IP("excluded ip", SubnetMask.class),
    ALLOWED_IPV6("excluded ipv6", SubnetMask.class),
    ALLOWED_DOMAIN("allowed domain", DomainMask.class),
    DISALLOWED_DOMAIN("disallowed domain", DomainMask.class),
    TRUSTED_DOMAIN("trusted domain", DomainMask.class),
    ALLOWED_FILE("allowed file", FilePathMask.class),
    DISALLOWED_FILE("disallowed file", FilePathMask.class),
    ALLOWED_CMD("allowed command", FilePathMask.class),
    DISALLOWED_CMD("disallowed command", FilePathMask.class);

    private final String value;
    private Class<? extends MatcherMask> supportMaskType;
    private static final Map<String, StringMatcherEnum> stringToEnum;

    private StringMatcherEnum(String v, Class<? extends MatcherMask> supportMaskType) {
        this.value = v;
        this.supportMaskType = supportMaskType;
    }

    public String value() {
        return this.value;
    }

    public Class<? extends MatcherMask> supportMaskType() {
        return this.supportMaskType;
    }

    public static StringMatcherEnum fromValue(String v) {
        String value = StringMatcherEnum.emptyToNull(v);
        if (value == null) {
            return null;
        }
        if (stringToEnum.containsKey(v)) {
            return stringToEnum.get(v);
        }
        throw new IllegalArgumentException(v);
    }

    private static String emptyToNull(String string) {
        return string == null || string.length() == 0 ? null : string;
    }

    public boolean isDomain() {
        return this == TRUSTED_DOMAIN || this == ALLOWED_DOMAIN || this == DISALLOWED_DOMAIN;
    }

    static {
        stringToEnum = new HashMap<String, StringMatcherEnum>();
        for (StringMatcherEnum item : StringMatcherEnum.values()) {
            if (stringToEnum.containsKey(item.value())) {
                throw new IllegalArgumentException("Duplicated enums, the values of enums should be unique : " + item.value());
            }
            stringToEnum.put(item.value(), item);
        }
        stringToEnum.put("intranet domain", DISALLOWED_DOMAIN);
        stringToEnum.put("excluded domain", ALLOWED_DOMAIN);
        stringToEnum.put("trusted ip", ALLOWED_IP);
    }
}

