/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util;

import com.aliyun.rapt.commons.utils.JavaVersion;
import com.aliyun.rapt.commons.utils.SystemUtils;
import com.aliyun.securitysdk.rass.util.AssertUtil;
import com.aliyun.securitysdk.rass.util.LRUCache;
import com.aliyun.securitysdk.rass.util.tuple.ImmutablePair;
import com.aliyun.securitysdk.rass.util.tuple.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.misc.Unsafe;

public abstract class ReflectionUtils {
    private static final Method[] NO_METHODS = new Method[0];
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new LRUCache(64);
    private static final Map<Pair<Class<?>, String>, Field> findFieldCache = new LRUCache(8);

    public static <T> T getNestedFieldValue(Object target, Field ... fields) {
        AssertUtil.checkArgument(fields != null && fields.length > 0, "Fields must not be null or empty");
        Object fieldValue = target;
        for (Field field : fields) {
            fieldValue = ReflectionUtils.getFieldValue(field, fieldValue);
        }
        return (T)fieldValue;
    }

    public static <T> T getFieldValue(Field field, Object target) {
        boolean accessible = field.isAccessible();
        try {
            if (!accessible) {
                field.setAccessible(true);
            }
            Object object = field.get(target);
            return (T)object;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> T getFieldValue(Class<?> clazz, String name, Object target) {
        return ReflectionUtils.getFieldValue(ReflectionUtils.findField(clazz, name), target);
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        AssertUtil.notNull(clazz, "Class must not be null");
        AssertUtil.checkArgument(name != null || type != null, "Either name or type of the field must be specified");
        Field f = findFieldCache.get(new ImmutablePair(clazz, name));
        if (f == null) {
            for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = searchType.getDeclaredFields()) {
                    if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                    findFieldCache.put(new ImmutablePair(clazz, name), field);
                    return field;
                }
            }
        }
        return f;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        AssertUtil.notNull(clazz, "Class must not be null");
        AssertUtil.notNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, new Object[0]);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        AssertUtil.notNull(clazz, "Class must not be null");
        Method[] result = declaredMethodsCache.get(clazz);
        if (result == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                declaredMethodsCache.put(clazz, result.length == 0 ? NO_METHODS : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        LinkedList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new LinkedList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void removeFinalModifierFromField(Field field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (!Modifier.isFinal(field.getModifiers())) {
            return;
        }
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return;
        }
        ReflectionUtils.removeFinalModifierFromFieldForJava12(field);
    }

    public static void removeFinalModifierFromFieldForJava12(Field field) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
        getDeclaredFields0.setAccessible(true);
        Object fields = getDeclaredFields0.invoke(Field.class, false);
        if (!(fields instanceof Field[])) {
            throw new IllegalStateException("Unexpected field type: " + fields.getClass());
        }
        for (Field f : (Field[])fields) {
            if (!f.getName().equals("modifiers")) continue;
            f.setAccessible(true);
            f.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            break;
        }
    }

    public static void setFinalField(Field field, Object target, Object value) throws Exception {
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20)) {
            ReflectionUtils.removeFinalModifierFromField(field);
            ReflectionUtils.setField(field, target, value);
        } else {
            ReflectionUtils.setFinalFieldByUnsafeForJava21(field, target, value);
        }
    }

    public static void setFinalFieldByUnsafeForJava21(Field field, Object target, Object value) {
        try {
            long offset;
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            if (target == null) {
                target = unsafe.staticFieldBase(field);
                offset = unsafe.staticFieldOffset(field);
            } else {
                offset = unsafe.objectFieldOffset(field);
            }
            if (field.getType() == Byte.TYPE) {
                unsafe.putByte(target, offset, ((Number)value).byteValue());
            } else if (field.getType() == Short.TYPE) {
                unsafe.putShort(target, offset, ((Number)value).shortValue());
            } else if (field.getType() == Integer.TYPE) {
                unsafe.putInt(target, offset, ((Number)value).intValue());
            } else if (field.getType() == Long.TYPE) {
                unsafe.putLong(target, offset, ((Number)value).longValue());
            } else if (field.getType() == Float.TYPE) {
                unsafe.putFloat(target, offset, ((Number)value).floatValue());
            } else if (field.getType() == Double.TYPE) {
                unsafe.putDouble(target, offset, ((Number)value).doubleValue());
            } else if (field.getType() == Character.TYPE) {
                unsafe.putChar(target, offset, ((Character)value).charValue());
            } else if (field.getType() == Boolean.TYPE) {
                unsafe.putBoolean(target, offset, (Boolean)value);
            } else {
                unsafe.putObject(target, offset, value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }
}

