/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resource;

import com.aliyun.rapt.commons.autoreload.PolicyReloadedListener;
import com.aliyun.rapt.commons.autoreload.PolicyResourceReloadMonitors;
import com.aliyun.rapt.commons.autoreload.config.AutoReloadConfig;
import com.aliyun.rapt.commons.autoreload.config.DiamondConfig;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.IOUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.RuntimeApplicationSecuritySandboxImpl;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.RassConstants;
import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import com.aliyun.securitysdk.rass.api.exception.InitializationException;
import com.aliyun.securitysdk.rass.api.util.OsUtils;
import com.aliyun.securitysdk.rass.config.schema.Authority;
import com.aliyun.securitysdk.rass.config.schema.Domains;
import com.aliyun.securitysdk.rass.config.schema.ExcludedHosts;
import com.aliyun.securitysdk.rass.config.schema.Hosts;
import com.aliyun.securitysdk.rass.config.schema.IntranetHosts;
import com.aliyun.securitysdk.rass.config.schema.Ips;
import com.aliyun.securitysdk.rass.config.schema.MatcherType;
import com.aliyun.securitysdk.rass.config.schema.PermissionCheckMode;
import com.aliyun.securitysdk.rass.config.schema.RassPolicy;
import com.aliyun.securitysdk.rass.config.schema.Socket;
import com.aliyun.securitysdk.rass.config.schema.TrustedHosts;
import com.aliyun.securitysdk.rass.permission.checker.CmdPermissionChecker;
import com.aliyun.securitysdk.rass.permission.checker.FilePermissionChecker;
import com.aliyun.securitysdk.rass.permission.checker.SerializationPermissionChecker;
import com.aliyun.securitysdk.rass.permission.checker.SocketPermissionChecker;
import com.aliyun.securitysdk.rass.resolver.PolicyParser;
import com.aliyun.securitysdk.rass.resolver.PolicyResolver;
import com.aliyun.securitysdk.rass.resolver.transformer.Socket2SocketPermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.resource.ResourceReloadListener;
import com.aliyun.securitysdk.rass.util.FileUtils;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcherEnum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class DynamicResourceManager
implements PolicyReloadedListener {
    private static final Logger logger = SecurityLogManager.getLogger(DynamicResourceManager.class);
    private static DynamicResourceManager instance;
    private static RassConfig rassConfig;
    private RassPolicy mergedPolicy;
    private final List<RassPolicy> availablePolicies = new ArrayList<RassPolicy>();
    private PolicyResolver policyResolver;
    private PolicyResourceReloadMonitors policyResourceReloadMonitors;
    private final List<ResourceReloadListener> resourceReloadListeners = new ArrayList<ResourceReloadListener>();
    private List<SocketPermissionChecker> ssrfPermissionCheckers = new ArrayList<SocketPermissionChecker>();
    private List<Socket.PermChecker> ssrfPermCheckers = new ArrayList<Socket.PermChecker>();

    public static void setRassConfig(RassConfig rassConfig) {
        DynamicResourceManager.rassConfig = rassConfig;
    }

    public RassPolicy getRassPolicy() {
        return this.mergedPolicy;
    }

    private void resolvePolicy() {
        if (this.mergedPolicy == null) {
            throw new InitializationException("rass policy should not be null");
        }
        this.policyResolver = new PolicyResolver(this.mergedPolicy);
        this.policyResolver.resolve();
    }

    public DynamicResourceManager() {
        this(true);
    }

    public DynamicResourceManager(boolean enableReloadMonitor) {
        if (rassConfig == null) {
            rassConfig = ConfigLoader.loadSecurityConfig();
        }
        this.parsePolicy();
        this.mergePolicy();
        this.resolvePolicy();
        if (enableReloadMonitor) {
            this.startResourceReloadMonitor();
        }
    }

    public void parsePolicy() {
        logger.info("Parsing policy...");
        String policyPath = "/rass-policy-internal.xml";
        InputStream resourceAsStream = RuntimeApplicationSecuritySandboxImpl.class.getResourceAsStream(policyPath);
        logger.info("Default policy file url is {}", (Object)RuntimeApplicationSecuritySandboxImpl.class.getResource(policyPath));
        RassPolicy policy = PolicyParser.parse(resourceAsStream);
        if (policy == null) {
            throw new SecurityException("rass policy parse error, please check policy format in " + policyPath);
        }
        this.availablePolicies.add(policy);
        policyPath = rassConfig.getDefaultPolicyPath();
        if (RuntimeApplicationSecuritySandboxImpl.class.getResource(policyPath) != null) {
            resourceAsStream = RuntimeApplicationSecuritySandboxImpl.class.getResourceAsStream(policyPath);
            logger.info("rass-policy.xml exists, url is {}", (Object)RuntimeApplicationSecuritySandboxImpl.class.getResource(policyPath));
            policy = PolicyParser.parse(resourceAsStream);
            if (policy == null) {
                throw new SecurityException("rass policy parse error, please check policy format in " + policyPath);
            }
            this.availablePolicies.add(policy);
        }
        if (RuntimeApplicationSecuritySandboxImpl.class.getResource(policyPath = rassConfig.getCustomPolicyPath()) != null) {
            logger.info("Custom policy file exists.");
            resourceAsStream = RuntimeApplicationSecuritySandboxImpl.class.getResourceAsStream(policyPath);
            policy = PolicyParser.parse(resourceAsStream);
            if (policy == null) {
                throw new SecurityException("rass policy parse error, please check policy format in " + policyPath);
            }
            this.availablePolicies.add(policy);
        }
        if (Files.exists(Paths.get(policyPath = rassConfig.getDynamicPolicyPath(), new String[0]), new LinkOption[0])) {
            logger.info("Dynamic policy file [{}] exists.", (Object)policyPath);
            resourceAsStream = FileUtils.openInputStreamQuietly(new File(policyPath));
            policy = PolicyParser.parse(resourceAsStream);
            if (policy == null) {
                throw new SecurityException("rass policy parse error, please check policy format in " + policyPath);
            }
            this.availablePolicies.add(policy);
        }
    }

    protected void mergePolicy() {
        logger.info("merging policy...");
        for (RassPolicy policy : this.availablePolicies) {
            if (this.mergedPolicy == null) {
                this.mergedPolicy = policy;
                if (this.mergedPolicy.getAuthority() != null) continue;
                Authority defaultAuthority = new Authority();
                defaultAuthority.setEnabled(true);
                this.mergedPolicy.setAuthority(defaultAuthority);
                continue;
            }
            Authority authority = policy.getAuthority();
            if (authority == null) continue;
            if (authority.getSocket() != null) {
                boolean hasValidPermChecker = false;
                for (Socket.PermChecker checker : authority.getSocket().getPermChecker()) {
                    if (!checker.isEnabled()) continue;
                    hasValidPermChecker = true;
                    break;
                }
                if (hasValidPermChecker) {
                    this.mergedPolicy.getAuthority().setSocket(authority.getSocket());
                }
            }
            if (authority.getCommand() != null) {
                this.mergedPolicy.getAuthority().setCommand(authority.getCommand());
            }
            if (authority.getFile() != null) {
                this.mergedPolicy.getAuthority().setFile(authority.getFile());
            }
            if (authority.getSerialization() == null) continue;
            this.mergedPolicy.getAuthority().setSerialization(authority.getSerialization());
        }
    }

    protected void startResourceReloadMonitor() {
        File f;
        if (rassConfig == null) {
            rassConfig = ConfigLoader.loadSecurityConfig();
        }
        AutoReloadConfig autoReloadConfig = new AutoReloadConfig();
        autoReloadConfig.setEnabled(rassConfig.isDynamicPolicyEnabled());
        autoReloadConfig.setDynamicPolicyPath(rassConfig.getDynamicPolicyPath());
        DiamondConfig diamondConfig = new DiamondConfig();
        diamondConfig.setEnabled(rassConfig.isDiamondEnabled());
        autoReloadConfig.setDiamond(diamondConfig);
        logger.info("Registering dynamic policy...");
        if (rassConfig.isDynamicPolicyEnabled() && !OsUtils.IS_OS_UNIX && !(f = new File(RassConstants.DYNAMIC_POLICY_PATH).getParentFile()).exists() && !f.mkdirs()) {
            rassConfig.setEnabled(false);
        }
        this.policyResourceReloadMonitors = new PolicyResourceReloadMonitors(autoReloadConfig, (PolicyReloadedListener)this);
        try {
            this.policyResourceReloadMonitors.start();
        }
        catch (Exception e) {
            logger.warn("start policy resource reload monitor error", (Throwable)e);
        }
    }

    public void registerResourceReloadListener(ResourceReloadListener listener) {
        this.resourceReloadListeners.add(listener);
    }

    public List<CmdPermissionChecker> getCmdPermissionCheckers() {
        return this.policyResolver.getCmdPermissionCheckers();
    }

    public List<FilePermissionChecker> getFilePermissionCheckers() {
        return this.policyResolver.getFilePermissionCheckers();
    }

    public List<SocketPermissionChecker> getSocketPermissionCheckers() {
        return this.policyResolver.getSocketPermissionCheckers();
    }

    public List<SerializationPermissionChecker> getSerializationPermissionCheckers() {
        return this.policyResolver.getSerializationPermissionCheckers();
    }

    public void reloadPolicy(InputStream configInfoInputStream) {
        logger.info("reloading policy...");
        RassPolicy rassPolicy = PolicyParser.parse(configInfoInputStream);
        if (rassPolicy == null || this.mergedPolicy.getVersion().equals(rassPolicy.getVersion())) {
            logger.info("Stop reloading since the new policy has the same version as current.");
            return;
        }
        String formerVersion = this.mergedPolicy.getVersion();
        this.mergedPolicy = rassPolicy;
        this.resolvePolicy();
        logger.info("resource reloaded, former version is {}, current version is: {}", (Object)formerVersion, (Object)rassPolicy.getVersion());
        for (ResourceReloadListener listener : this.resourceReloadListeners) {
            listener.onReload();
        }
    }

    public synchronized void removeSsrfRule(String matcherName, String ... matcherMasks) {
        Socket.PermChecker permChecker = this.getSsrfPermCheckerForModify();
        StringMatcherEnum matcherEnum = StringMatcherEnum.fromValue(matcherName);
        Objects.requireNonNull(matcherEnum);
        HashSet<String> ruleSet = new HashSet<String>(this.listSsrfRule(permChecker, matcherEnum));
        if (!matcherEnum.isDomain()) {
            ruleSet.removeAll(Arrays.asList(matcherMasks));
        } else {
            for (String rule : matcherMasks) {
                int idx = rule.indexOf(47);
                if (idx == -1 || rule.endsWith("/Trie")) {
                    if (idx == -1) {
                        rule = rule + "/Trie";
                    }
                    ruleSet.remove(rule);
                    if (rule.startsWith("*")) continue;
                    ruleSet.remove("*." + rule);
                    continue;
                }
                ruleSet.remove(rule);
            }
        }
        this.configureSsrfRule(permChecker, matcherEnum, ruleSet);
    }

    public synchronized void addSsrfRule(String matcherName, String ... matcherMasks) {
        Socket.PermChecker permChecker = this.getSsrfPermCheckerForModify();
        StringMatcherEnum matcherEnum = StringMatcherEnum.fromValue(matcherName);
        Objects.requireNonNull(matcherEnum);
        HashSet<String> ruleSet = new HashSet<String>(this.listSsrfRule(permChecker, matcherEnum));
        if (!matcherEnum.isDomain()) {
            ruleSet.addAll(Arrays.asList(matcherMasks));
        } else {
            for (String rule : matcherMasks) {
                if (rule.indexOf(47) == -1) {
                    ruleSet.add(rule + "/Trie");
                    continue;
                }
                ruleSet.add(rule);
            }
        }
        this.configureSsrfRule(permChecker, matcherEnum, ruleSet);
    }

    public synchronized List<String> listSsrfRule(String matcherName) {
        Socket.PermChecker permChecker = this.getSsrfPermCheckerForModify();
        StringMatcherEnum matcherEnum = StringMatcherEnum.fromValue(matcherName);
        Objects.requireNonNull(matcherEnum);
        return this.listSsrfRule(permChecker, matcherEnum);
    }

    public List<String> listSsrfRule(Socket.PermChecker permChecker, StringMatcherEnum matcherEnum) {
        List<?> patternList = this.getSocketPatternList(permChecker, Objects.requireNonNull(matcherEnum));
        ArrayList<String> result = new ArrayList<String>();
        if (!matcherEnum.isDomain()) {
            result.addAll(patternList);
        } else {
            for (Domains.Domain d : patternList) {
                result.add(d.getPattern() + "/" + d.getMatcherType().value());
            }
        }
        return result;
    }

    public void configureSsrfRule(String matcherName, String ... matcherMasks) {
        Socket.PermChecker permChecker = this.getSsrfPermCheckerForModify();
        StringMatcherEnum matcherEnum = StringMatcherEnum.fromValue(matcherName);
        this.configureSsrfRule(permChecker, Objects.requireNonNull(matcherEnum), Arrays.asList(matcherMasks));
    }

    private synchronized void configureSsrfRule(Socket.PermChecker permChecker, StringMatcherEnum matcherEnum, Collection<String> matcherMasks) {
        boolean isDomain = matcherEnum.isDomain();
        List<?> patternList = this.getSocketPatternList(permChecker, matcherEnum);
        patternList.clear();
        if (!isDomain) {
            patternList.addAll(matcherMasks);
        } else {
            HashSet<String> ruleSet = new HashSet<String>();
            for (String rule : matcherMasks) {
                int index = rule.lastIndexOf(47);
                if (rule.endsWith("/Trie") || index == -1) {
                    if (index == -1) {
                        rule = rule + "/Trie";
                    }
                    if (!rule.startsWith("*")) {
                        ruleSet.add("*." + rule);
                    }
                }
                ruleSet.add(rule);
            }
            for (String rule : ruleSet) {
                Domains.Domain d = new Domains.Domain();
                int index = rule.lastIndexOf(47);
                if (index != -1) {
                    d.setPattern(rule.substring(0, index));
                    d.setMatcherType(MatcherType.fromValue(rule.substring(index + 1)));
                } else {
                    d.setPattern(rule);
                }
                patternList.add(d);
            }
        }
        Socket socket = new Socket();
        socket.getPermChecker().add(permChecker);
        this.ssrfPermissionCheckers = new Socket2SocketPermissionCheckerTransformer().transform(socket);
    }

    private List<?> getSocketPatternList(Socket.PermChecker permChecker, StringMatcherEnum matcherEnum) {
        Hosts hosts = null;
        switch (matcherEnum) {
            case INTRANET_IP: 
            case INTRANET_IPV6: 
            case DISALLOWED_DOMAIN: {
                hosts = permChecker.getIntranetHosts();
                if (hosts != null) break;
                hosts = new IntranetHosts();
                permChecker.setIntranetHosts((IntranetHosts)hosts);
                break;
            }
            case ALLOWED_IP: 
            case ALLOWED_IPV6: 
            case ALLOWED_DOMAIN: {
                hosts = permChecker.getExcludedHosts();
                if (hosts != null) break;
                hosts = new ExcludedHosts();
                permChecker.setExcludedHosts((ExcludedHosts)hosts);
                break;
            }
            case TRUSTED_DOMAIN: {
                hosts = permChecker.getTrustedHosts();
                if (hosts != null) break;
                hosts = new TrustedHosts();
                permChecker.setTrustedHosts((TrustedHosts)hosts);
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong matcher enum");
            }
        }
        Ips ips = null;
        switch (matcherEnum) {
            case INTRANET_IP: 
            case INTRANET_IPV6: 
            case ALLOWED_IP: 
            case ALLOWED_IPV6: {
                ips = hosts.getIps();
                if (ips != null) break;
                ips = new Ips();
                hosts.setIps(ips);
                break;
            }
            case DISALLOWED_DOMAIN: 
            case ALLOWED_DOMAIN: 
            case TRUSTED_DOMAIN: {
                Domains ds = hosts.getDomains();
                if (ds == null) {
                    ds = new Domains();
                    hosts.setDomains(ds);
                }
                return ds.getDomain();
            }
            default: {
                throw new IllegalArgumentException("wrong matcher enum");
            }
        }
        switch (matcherEnum) {
            case INTRANET_IP: 
            case ALLOWED_IP: {
                return ips.getIp();
            }
            case INTRANET_IPV6: 
            case ALLOWED_IPV6: {
                return ips.getIpv6();
            }
        }
        throw new IllegalArgumentException("wrong matcher enum");
    }

    private Socket.PermChecker getSsrfPermCheckerForModify() {
        List<Socket.PermChecker> permCheckers = this.getSsrfPermCheckers();
        if (permCheckers.size() > 1) {
            throw new RuntimeException("too many ssrf perm checkers");
        }
        if (permCheckers.isEmpty()) {
            throw new RuntimeException("no ssrf perm checker");
        }
        return permCheckers.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocketPermissionChecker> getSsrfPermissionCheckers() {
        if (!this.ssrfPermissionCheckers.isEmpty()) {
            return this.ssrfPermissionCheckers;
        }
        Class<DynamicResourceManager> clazz = DynamicResourceManager.class;
        synchronized (DynamicResourceManager.class) {
            if (!this.ssrfPermissionCheckers.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.ssrfPermissionCheckers;
            }
            ArrayList<SocketPermissionChecker> tmpSocketPermissionCheckers = new ArrayList<SocketPermissionChecker>();
            for (SocketPermissionChecker checker : this.getSocketPermissionCheckers()) {
                if (checker.getPermissionMode() != PermissionMode.Manual) continue;
                tmpSocketPermissionCheckers.add(checker);
            }
            this.ssrfPermissionCheckers = tmpSocketPermissionCheckers;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ssrfPermissionCheckers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Socket.PermChecker> getSsrfPermCheckers() {
        if (!this.ssrfPermCheckers.isEmpty()) {
            return this.ssrfPermCheckers;
        }
        Class<DynamicResourceManager> clazz = DynamicResourceManager.class;
        synchronized (DynamicResourceManager.class) {
            if (!this.ssrfPermCheckers.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.ssrfPermCheckers;
            }
            ArrayList<Socket.PermChecker> tmpSsrfPermCheckers = new ArrayList<Socket.PermChecker>();
            for (Socket.PermChecker c : this.getRassPolicy().getAuthority().getSocket().getPermChecker()) {
                if (c.getMode() != PermissionCheckMode.MANUAL) continue;
                tmpSsrfPermCheckers.add(c);
            }
            this.ssrfPermCheckers = tmpSsrfPermCheckers;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ssrfPermCheckers;
        }
    }

    public static DynamicResourceManager getInstance(boolean enableReloadMonitor) {
        if (instance == null) {
            instance = new DynamicResourceManager(enableReloadMonitor);
        }
        if (enableReloadMonitor && DynamicResourceManager.instance.policyResourceReloadMonitors == null) {
            instance.startResourceReloadMonitor();
        }
        return instance;
    }

    public static DynamicResourceManager getInstance() {
        return DynamicResourceManager.getInstance(true);
    }

    public void reload(String policy) {
        try {
            this.reloadPolicy(IOUtils.toInputStream((String)policy, (String)"UTF-8"));
        }
        catch (IOException e) {
            logger.warn("read policy error {}", (Throwable)e);
        }
    }
}

