/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.transformer;

import com.aliyun.securitysdk.rass.config.schema.Serialization;
import com.aliyun.securitysdk.rass.util.FastJSONRuleList;
import java.util.ArrayList;
import java.util.HashSet;

public class Serialization2FastJsonRuleListTransformer {
    public FastJSONRuleList transform(Serialization serialization) {
        String[] patterns;
        ArrayList<String> denyClasses = new ArrayList<String>();
        ArrayList<String> allowClasses = new ArrayList<String>();
        StringBuilder formalPattern = new StringBuilder();
        for (Serialization.PermChecker permChecker : serialization.getPermChecker()) {
            Serialization.PermChecker.SerializePatternList serializePatternList = permChecker.getSerializePatternList();
            HashSet<String> patterns2 = new HashSet<String>(serializePatternList.getSerializePattern());
            for (String pattern : patterns2) {
                if (pattern.endsWith(":enabledSubclass") || pattern.endsWith(":enabledSubclass=true")) {
                    String className;
                    boolean neg = pattern.startsWith("!");
                    if (neg) {
                        className = pattern.substring(1, pattern.indexOf(58));
                        denyClasses.add(className);
                        continue;
                    }
                    className = pattern.substring(0, pattern.indexOf(58));
                    allowClasses.add(className);
                    continue;
                }
                if (pattern.endsWith(":oisonly")) continue;
                formalPattern.append(pattern).append(';');
            }
        }
        for (String pattern : patterns = formalPattern.toString().split(";")) {
            boolean negate;
            int nameLen = pattern.length();
            if (nameLen == 0 || this.parseLimit(pattern)) continue;
            boolean bl = negate = pattern.charAt(0) == '!';
            if (pattern.endsWith("*")) {
                pattern = pattern.replace("*", "");
                if (negate) {
                    pattern = pattern.substring(1);
                    denyClasses.add(pattern);
                    continue;
                }
                allowClasses.add(pattern);
                continue;
            }
            if (negate) {
                pattern = pattern.substring(1);
                denyClasses.add(pattern);
                continue;
            }
            allowClasses.add(pattern);
        }
        return new FastJSONRuleList(denyClasses, allowClasses);
    }

    private boolean parseLimit(String pattern) {
        int eqNdx = pattern.indexOf(61);
        if (eqNdx < 0) {
            return false;
        }
        if (!(pattern.startsWith("maxdepth=") || pattern.startsWith("maxarray=") || pattern.startsWith("maxrefs=") || pattern.startsWith("maxbytes="))) {
            throw new IllegalArgumentException("unknown limit: " + pattern.substring(0, eqNdx));
        }
        return true;
    }
}

