/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.transformer;

import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.config.schema.Command;
import com.aliyun.securitysdk.rass.config.schema.CommandMatchableList;
import com.aliyun.securitysdk.rass.permission.checker.CmdPermissionChecker;
import com.aliyun.securitysdk.rass.resolver.Matchable2StringMatcherFactory;
import com.aliyun.securitysdk.rass.resolver.transformer.BasePermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.BasicTrieNodeConverter;
import java.util.ArrayList;
import java.util.List;

public class Command2CmdPermissionCheckerTransformer
extends BasePermissionCheckerTransformer {
    public List<CmdPermissionChecker> transform(Command command) {
        ArrayList<CmdPermissionChecker> resultCheckers = new ArrayList<CmdPermissionChecker>();
        for (Command.PermChecker permChecker : command.getPermChecker()) {
            if (!permChecker.isEnabled()) continue;
            ArrayList<CommandMatchableList.CommandMatcher> matchables = new ArrayList<CommandMatchableList.CommandMatcher>();
            List<Command.PermChecker.AllowedCommandList> allowedCommandList = permChecker.getAllowedCommandList();
            for (CommandMatchableList commandMatchableList : allowedCommandList) {
                matchables.addAll(commandMatchableList.getCommandMatcher());
            }
            StringMatcher stringMatcher = Matchable2StringMatcherFactory.toStringMatcher(matchables, new BasicTrieNodeConverter(), true);
            ArrayList<CommandMatchableList.CommandMatcher> arrayList = new ArrayList<CommandMatchableList.CommandMatcher>();
            List<Command.PermChecker.DisallowedCommandList> disallowedCommandList = permChecker.getDisallowedCommandList();
            for (CommandMatchableList commandMatchableList : disallowedCommandList) {
                arrayList.addAll(commandMatchableList.getCommandMatcher());
            }
            StringMatcher disallowedStringMatcher = Matchable2StringMatcherFactory.toStringMatcher(arrayList, new BasicTrieNodeConverter(), true);
            PermissionMode permissionMode = PermissionMode.toMode((String)permChecker.getMode().value());
            Action[] actions = this.getActions(permChecker);
            CmdPermissionChecker cmdPermissionChecker = new CmdPermissionChecker(stringMatcher, disallowedStringMatcher, permissionMode, true, actions);
            cmdPermissionChecker.setShouldCheckStackMatcher(this.resolveStack(permChecker.getEnabledStackMatchers()));
            cmdPermissionChecker.setAllowedStackMatcher(this.resolveStack(permChecker.getAllowStackMatchers()));
            cmdPermissionChecker.setDisallowedStackMatcher(this.resolveStack(permChecker.getDisallowStackMatchers()));
            resultCheckers.add(cmdPermissionChecker);
        }
        return resultCheckers;
    }
}

