/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.formatter;

import com.aliyun.securitysdk.rass.resolver.formatter.StringListFormatter;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.SubnetMask;
import com.aliyun.securitysdk.rass.util.AssertUtil;
import com.aliyun.securitysdk.rass.util.IpAddressUtil;
import java.util.ArrayList;
import java.util.List;

public class Ips2SubnetMasksStringListFormatter
implements StringListFormatter<SubnetMask> {
    @Override
    public List<String> format(List<SubnetMask> ips) {
        ArrayList<String> result = new ArrayList<String>();
        for (SubnetMask subnetMask : AssertUtil.notNull(ips, "ips should not be null.")) {
            String ipAddressBinaryArray = IpAddressUtil.convertIpv4ToString(subnetMask.getAddress());
            if (ipAddressBinaryArray == null) {
                throw new RuntimeException("Failed to parse " + subnetMask);
            }
            if (subnetMask.getMask() == 32 || subnetMask.getMask() == -1) {
                result.add(ipAddressBinaryArray);
                continue;
            }
            ipAddressBinaryArray = ipAddressBinaryArray.substring(0, subnetMask.getMask());
            result.add(ipAddressBinaryArray + '*');
        }
        return result;
    }
}

