/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.RassConstants;
import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import com.aliyun.securitysdk.rass.api.provider.InformationProvider;
import com.aliyun.securitysdk.rass.config.schema.Authority;
import com.aliyun.securitysdk.rass.config.schema.BasePermChecker;
import com.aliyun.securitysdk.rass.config.schema.Command;
import com.aliyun.securitysdk.rass.config.schema.File;
import com.aliyun.securitysdk.rass.config.schema.FileMatchableList;
import com.aliyun.securitysdk.rass.config.schema.InfoProviderList;
import com.aliyun.securitysdk.rass.config.schema.MatcherType;
import com.aliyun.securitysdk.rass.config.schema.NativeGrant;
import com.aliyun.securitysdk.rass.config.schema.PermissionCheckMode;
import com.aliyun.securitysdk.rass.config.schema.RassPolicy;
import com.aliyun.securitysdk.rass.config.schema.Serialization;
import com.aliyun.securitysdk.rass.config.schema.Socket;
import com.aliyun.securitysdk.rass.permission.checker.CmdPermissionChecker;
import com.aliyun.securitysdk.rass.permission.checker.FilePermissionChecker;
import com.aliyun.securitysdk.rass.permission.checker.SerializationPermissionChecker;
import com.aliyun.securitysdk.rass.permission.checker.SocketPermissionChecker;
import com.aliyun.securitysdk.rass.resolver.transformer.Command2CmdPermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.resolver.transformer.File2FilePermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.resolver.transformer.InformationTransformer;
import com.aliyun.securitysdk.rass.resolver.transformer.Serialization2SerializationPermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.resolver.transformer.Socket2SocketPermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class PolicyResolver {
    private static final Logger logger = SecurityLogManager.getLogger(PolicyResolver.class);
    private RassPolicy policy;
    private InfoProviderList infoProviderList;
    private NativeGrant nativeGrant;
    private Authority authority;
    private List<InformationProvider> informationProviders;
    private List<CmdPermissionChecker> cmdPermissionCheckers;
    private List<FilePermissionChecker> filePermissionCheckers;
    private List<SocketPermissionChecker> socketPermissionCheckers;
    private List<SerializationPermissionChecker> serializationPermissionCheckers;
    private InformationTransformer informationTransformer;
    private File2FilePermissionCheckerTransformer fileTransformer;
    private Command2CmdPermissionCheckerTransformer commandTransformer;
    private Socket2SocketPermissionCheckerTransformer socketTransformer;
    private Serialization2SerializationPermissionCheckerTransformer serializationTransformer;

    public PolicyResolver(@NonNull RassPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        this.policy = policy;
        this.infoProviderList = policy.getInfoProviderList();
        this.nativeGrant = policy.getNativeGrant();
        this.authority = policy.getAuthority();
        this.informationTransformer = new InformationTransformer();
        this.fileTransformer = new File2FilePermissionCheckerTransformer();
        this.commandTransformer = new Command2CmdPermissionCheckerTransformer();
        this.socketTransformer = new Socket2SocketPermissionCheckerTransformer();
        this.serializationTransformer = new Serialization2SerializationPermissionCheckerTransformer();
    }

    public void resolve() {
        this.informationProviders = this.resolveInformationProvider();
        this.cmdPermissionCheckers = this.resolveCmdPermissionChecker();
        this.filePermissionCheckers = this.resolveFilePermissionChecker();
        this.socketPermissionCheckers = this.resolveSocketPermissionChecker();
        this.serializationPermissionCheckers = this.resolveEnhancedObjectInputFilter();
    }

    public List<CmdPermissionChecker> resolveCmdPermissionChecker() {
        Command command = this.authority.getCommand();
        if (command == null) {
            return Collections.emptyList();
        }
        return this.commandTransformer.transform(command);
    }

    public List<FilePermissionChecker> resolveFilePermissionChecker() {
        File file = this.authority.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        RassConfig rassConfig = ConfigLoader.loadSecurityConfig();
        if (rassConfig.isSelfConfigProtection()) {
            file.getPermChecker().add(this.generateSelfProtectionFilePermChecker());
        } else {
            logger.warn("self protection rules is disabled");
        }
        return this.fileTransformer.transform(file);
    }

    public List<SocketPermissionChecker> resolveSocketPermissionChecker() {
        Socket socket = this.authority.getSocket();
        if (socket == null || !ClassUtils.isNetHooksProviderPresent()) {
            return Collections.emptyList();
        }
        return this.socketTransformer.transform(socket);
    }

    public List<SerializationPermissionChecker> resolveEnhancedObjectInputFilter() {
        Serialization serialization = this.authority.getSerialization();
        if (serialization == null || !ClassUtils.isObjectInputFilterClassPresent()) {
            return Collections.emptyList();
        }
        return this.serializationTransformer.transform(serialization);
    }

    private List<InformationProvider> resolveInformationProvider() {
        if (this.infoProviderList == null) {
            return Collections.emptyList();
        }
        List<InfoProviderList.InfoProvider> infoProviders = this.infoProviderList.getInfoProvider();
        if (infoProviders == null || infoProviders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InformationProvider> results = new ArrayList<InformationProvider>();
        for (InfoProviderList.InfoProvider infoProvider : infoProviders) {
            InformationProvider informationProvider = this.informationTransformer.transform(infoProvider);
            if (informationProvider == null) continue;
            results.add(informationProvider);
        }
        return results;
    }

    private File.PermChecker generateSelfProtectionFilePermChecker() {
        File.PermChecker.DisallowedFileList disallowedFileList = new File.PermChecker.DisallowedFileList();
        for (String pattern : Arrays.asList(RassConstants.DYNAMIC_POLICY_PATH, RassConstants.DYNAMIC_RASS_PROPERTIES_PATH)) {
            FileMatchableList.FileMatcher fileMatcher = new FileMatchableList.FileMatcher();
            fileMatcher.setMatcherType(MatcherType.PRECISE);
            fileMatcher.setPattern(pattern);
            disallowedFileList.getFileMatcher().add(fileMatcher);
        }
        File.PermChecker permChecker = new File.PermChecker();
        permChecker.getDisallowedFileList().add(disallowedFileList);
        BasePermChecker.ActionList actionList = new BasePermChecker.ActionList();
        actionList.getAction().add("write");
        permChecker.setActionList(actionList);
        permChecker.setMode(PermissionCheckMode.OPERATION);
        permChecker.setName("file_self_protection");
        return permChecker;
    }

    public RassPolicy getPolicy() {
        return this.policy;
    }

    public InfoProviderList getInfoProviderList() {
        return this.infoProviderList;
    }

    public NativeGrant getNativeGrant() {
        return this.nativeGrant;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public List<InformationProvider> getInformationProviders() {
        return this.informationProviders;
    }

    public List<CmdPermissionChecker> getCmdPermissionCheckers() {
        return this.cmdPermissionCheckers;
    }

    public List<FilePermissionChecker> getFilePermissionCheckers() {
        return this.filePermissionCheckers;
    }

    public List<SocketPermissionChecker> getSocketPermissionCheckers() {
        return this.socketPermissionCheckers;
    }

    public List<SerializationPermissionChecker> getSerializationPermissionCheckers() {
        return this.serializationPermissionCheckers;
    }

    public InformationTransformer getInformationTransformer() {
        return this.informationTransformer;
    }

    public File2FilePermissionCheckerTransformer getFileTransformer() {
        return this.fileTransformer;
    }

    public Command2CmdPermissionCheckerTransformer getCommandTransformer() {
        return this.commandTransformer;
    }

    public Socket2SocketPermissionCheckerTransformer getSocketTransformer() {
        return this.socketTransformer;
    }

    public Serialization2SerializationPermissionCheckerTransformer getSerializationTransformer() {
        return this.serializationTransformer;
    }
}

