/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver;

import com.aliyun.securitysdk.rass.config.schema.Matchable;
import com.aliyun.securitysdk.rass.config.schema.MatcherType;
import com.aliyun.securitysdk.rass.util.matcher.DelegateStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.HorspoolStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.NotStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.PreciseStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.TrieStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.WildcardStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.HostLetterTrieNodeConverter;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.TrieNodeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import lombok.NonNull;

public abstract class Matchable2StringMatcherFactory {
    private static StringMatcher toStringMatcher0(@NonNull MatcherType matcherType, String expression) {
        if (matcherType == null) {
            throw new NullPointerException("matcherType is marked non-null but is null");
        }
        switch (matcherType) {
            case PRECISE: {
                return new PreciseStringMatcher(expression);
            }
            case CONTAINS: {
                return new HorspoolStringMatcher(expression);
            }
            case WILDCARD: {
                return new WildcardStringMatcher(expression);
            }
        }
        return null;
    }

    public static StringMatcher toStringMatcher(@NonNull Matchable matchable) {
        if (matchable == null) {
            throw new NullPointerException("matchable is marked non-null but is null");
        }
        String expression = matchable.getPattern();
        boolean notExpression = expression.startsWith("!");
        if (notExpression) {
            expression = expression.substring(1);
        }
        StringMatcher stringMatcher = Matchable2StringMatcherFactory.toStringMatcher0(matchable.getMatcherType(), expression);
        if (notExpression) {
            stringMatcher = new NotStringMatcher(stringMatcher);
        }
        return stringMatcher;
    }

    public static StringMatcher toStringMatcher(Collection<? extends Matchable> expressions) {
        return Matchable2StringMatcherFactory.toStringMatcher(expressions, new HostLetterTrieNodeConverter(), false);
    }

    public static StringMatcher toStringMatcher(Collection<? extends Matchable> expressions, TrieNodeConverter trieNodeConverter, boolean prefix) {
        ArrayList<StringMatcher> stringMatchers = new ArrayList<StringMatcher>();
        HashSet<String> triePatterns = new HashSet<String>();
        for (Matchable matchable : expressions) {
            StringMatcher stringMatcher = Matchable2StringMatcherFactory.toStringMatcher0(matchable.getMatcherType(), matchable.getPattern());
            if (stringMatcher == null) {
                triePatterns.add(matchable.getPattern());
                continue;
            }
            stringMatchers.add(stringMatcher);
        }
        if (!triePatterns.isEmpty()) {
            stringMatchers.add(new TrieStringMatcher(trieNodeConverter, prefix).addItems(triePatterns));
        }
        return new DelegateStringMatcher(stringMatchers);
    }
}

