/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.permission.checker;

import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.ext.ConfigurablePermissionChecker;
import com.aliyun.securitysdk.rass.permission.stack.StackMatcher;
import java.util.List;

public abstract class BasePermissionChecker<T extends Permission>
extends ConfigurablePermissionChecker<T> {
    public static final String BLOCK_ACTION = "[block] ";
    public static final String OBSERVE_ACTION = "[observe] ";
    protected StackMatcher shouldCheckStackMatcher;
    protected StackMatcher allowedStackMatcher;
    protected StackMatcher disallowedStackMatcher;

    public BasePermissionChecker(String name) {
        super(name);
    }

    public BasePermissionChecker(boolean enabled, String name) {
        super(enabled, name);
    }

    public BasePermissionChecker(boolean enabled, String name, PermissionMode permissionMode, Action ... actions) {
        super(enabled, name, permissionMode, actions);
    }

    protected boolean checkAllowStack() {
        return this.allowedStackMatcher != null && this.allowedStackMatcher.match();
    }

    protected boolean checkDisallowStack() {
        return this.disallowedStackMatcher != null && this.disallowedStackMatcher.match();
    }

    protected boolean isEnabledStack() {
        if (this.shouldCheckStackMatcher == null) {
            return true;
        }
        return this.shouldCheckStackMatcher.match();
    }

    public boolean shouldCheck(Permission permission) {
        List actions = permission.getActionList();
        if (actions == null || actions.isEmpty()) {
            return true;
        }
        for (Action action : actions) {
            if ((action.getCode() & this.getActionBit()) == 0) continue;
            return true;
        }
        return false;
    }

    public StackMatcher getShouldCheckStackMatcher() {
        return this.shouldCheckStackMatcher;
    }

    public void setShouldCheckStackMatcher(StackMatcher shouldCheckStackMatcher) {
        this.shouldCheckStackMatcher = shouldCheckStackMatcher;
    }

    public StackMatcher getAllowedStackMatcher() {
        return this.allowedStackMatcher;
    }

    public void setAllowedStackMatcher(StackMatcher allowedStackMatcher) {
        this.allowedStackMatcher = allowedStackMatcher;
    }

    public StackMatcher getDisallowedStackMatcher() {
        return this.disallowedStackMatcher;
    }

    public void setDisallowedStackMatcher(StackMatcher disallowedStackMatcher) {
        this.disallowedStackMatcher = disallowedStackMatcher;
    }
}

