/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.net;

import com.aliyun.rapt.commons.utils.JavaVersion;
import com.aliyun.rapt.commons.utils.SystemUtils;
import com.aliyun.securitysdk.rass.net.NetHooksEvent;
import com.aliyun.securitysdk.rass.net.NetHooksEventListener;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import sun.net.NetHooks;

public class AliyunSecurityNetHooksProvider
extends NetHooks.Provider {
    private NetHooks.Provider delegate;
    private static final List<NetHooksEventListener> registeredListener = new CopyOnWriteArrayList<NetHooksEventListener>();

    public AliyunSecurityNetHooksProvider(NetHooks.Provider provider) {
        this.delegate = provider;
    }

    public static void registerListener(NetHooksEventListener listener) {
        registeredListener.add(listener);
    }

    static void setProvider(Field field) throws Exception {
        if (field != null) {
            field.setAccessible(true);
            if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20)) {
                ReflectionUtils.removeFinalModifierFromField(field);
            }
            ReflectionUtils.setFinalField(field, null, new AliyunSecurityNetHooksProvider((NetHooks.Provider)field.get(NetHooks.class)));
        }
    }

    @Override
    public void implBeforeTcpBind(FileDescriptor fileDescriptor, InetAddress inetAddress, int port) throws IOException {
        for (NetHooksEventListener netHooksEventListener : registeredListener) {
            netHooksEventListener.handleBeforeTcpBind(new NetHooksEvent(inetAddress, port));
        }
        this.delegate.implBeforeTcpBind(fileDescriptor, inetAddress, port);
    }

    @Override
    public void implBeforeTcpConnect(FileDescriptor fileDescriptor, InetAddress inetAddress, int port) throws IOException {
        for (NetHooksEventListener netHooksEventListener : registeredListener) {
            netHooksEventListener.handleBeforeTcpConnect(new NetHooksEvent(inetAddress, port));
        }
        this.delegate.implBeforeTcpConnect(fileDescriptor, inetAddress, port);
    }

    static {
        try {
            AliyunSecurityNetHooksProvider.setProvider(NetHooks.class.getDeclaredField("provider"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

