/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PandoraPropertyModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(PandoraPropertyModifier.class);
    private static final String PANDORA_BASE_LAUNCH_URL_CLASS_LOADER_NAME = "com.taobao.pandora.boot.loader.BaseLaunchURLClassLoader";
    private static final String PANDORA_STATIC_JARS_ENABLED_PROPERTY = "pandora.boot.statistic.jars.enable";
    private static final String ENABLE_CLASS_JAR_INFO = "enableClassJarInfo";
    private static final String WIKI_URL = "http://gitlab.alibaba-inc.com/middleware-container/pandora-boot/wikis/changelog";

    @Override
    public void modifyProperty() {
        PandoraPropertyModifier.force2DisablePandoraClassJarInfo();
    }

    private static void force2DisablePandoraClassJarInfo() {
        logger.info("Set {} = false", (Object)PANDORA_STATIC_JARS_ENABLED_PROPERTY);
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(PandoraPropertyModifier.PANDORA_STATIC_JARS_ENABLED_PROPERTY, "false");
            }
        });
        Class<?> clazz = ClassUtils.forNameQuietly(PANDORA_BASE_LAUNCH_URL_CLASS_LOADER_NAME, ClassLoader.getSystemClassLoader());
        if (clazz != null) {
            Field field = ReflectionUtils.findField(clazz, ENABLE_CLASS_JAR_INFO);
            if (field != null) {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                ReflectionUtils.setField(field, null, false);
                field.setAccessible(isAccessible);
            } else {
                logger.warn("\u4e0d\u5b89\u5168\u7684Pandora\u7248\u672c\uff0c\u8bf7\u53c2\u8003\u5982\u4e0b\u94fe\u63a5\u5347\u7ea7\uff1a{}", (Object)WIKI_URL);
            }
        }
    }
}

